<?php

namespace app\controllers;

use app\models\Categorias;
use app\models\CategoriasSearch;
use app\models\Parametros;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;
use Yii;

/**
 * CategoriasController implements the CRUD actions for Categorias model.
 */
class CategoriasController extends Controller
{
    /**
     * @inheritDoc
     */
    public function behaviors()
    {
        return array_merge(
            parent::behaviors(),
            [
                'verbs' => [
                    'class' => VerbFilter::className(),
                    'actions' => [
                        'delete' => ['POST'],
                    ],
                ],
            ]
        );
    }


    public function beforeAction($action)
    {
        $userModel = Yii::$app->user->identity;

        // Redirige si el usuario no está logueado
        if (Yii::$app->user->isGuest) {
            return $this->redirect(['site/login']);
        }

        // Redirige si el usuario no es superAdmin para las acciones update, create, delete
        if (in_array($action->id, ['update', 'create', 'delete'])) {
            if ($userModel->rol !== 'superAdmin') {
                return $this->redirect(['site/access-denied']);
            }
        }

        // Redirige si el usuario no es superAdmin ni vendedor para la acción index
        if ($action->id === 'index') {
            if (!in_array($userModel->rol, ['superAdmin', 'vendedor'])) {
                return $this->redirect(['site/access-denied']);
            }
        }

        return parent::beforeAction($action);
    }


    /**
     * Lists all Categorias models.
     *
     * @return string
     */
    public function actionIndex()
    {
        $this->layout = 'dashboard';
        $searchModel = new CategoriasSearch();
        $dataProvider = $searchModel->search($this->request->queryParams);

        return $this->render('index', [
            'searchModel' => $searchModel,
            'dataProvider' => $dataProvider,
        ]);
    }

    /**
     * Displays a single Categorias model.
     * @param int $cat_id Cat ID
     * @return string
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionView($cat_id)
    {
        $this->layout = 'dashboard';
        return $this->render('view', [
            'model' => $this->findModel($cat_id),
        ]);
    }

    /**
     * Creates a new Categorias model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     * @return string|\yii\web\Response
     */
    public function actionCreate()
    {
        date_default_timezone_set('America/Guayaquil'); //1:::HORA DE GUAYAQUIL
        $this->layout = 'dashboard';
        $model = new Categorias();

        if ($this->request->isPost) {

            $model->created_by = Yii::$app->user->id;
            $model->updated_by = Yii::$app->user->id;
            $model->created_at = date('Y-m-d H:i:s');
            $model->updated_at = date('Y-m-d H:i:s');
            if ($model->load($this->request->post()) && $model->save()) {
                return $this->redirect(['index']);
            }
        } else {
            $model->loadDefaultValues();
        }

        return $this->render('create', [
            'model' => $model,
        ]);
    }

    /**
     * Updates an existing Categorias model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param int $cat_id Cat ID
     * @return string|\yii\web\Response
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionUpdate($cat_id)
    {
        date_default_timezone_set('America/Guayaquil'); //1:::HORA DE GUAYAQUIL
        $this->layout = 'dashboard';
        $model = $this->findModel($cat_id);

        $model->updated_by = Yii::$app->user->id;
        $model->updated_at = date('Y-m-d H:i:s');

        if ($this->request->isPost && $model->load($this->request->post()) && $model->save()) {
            return $this->redirect(['view', 'cat_id' => $model->cat_id]);
        }

        return $this->render('update', [
            'model' => $model,
        ]);
    }

    /**
     * Deletes an existing Categorias model.
     * If deletion is successful, the browser will be redirected to the 'index' page.
     * @param int $cat_id Cat ID
     * @return \yii\web\Response
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionDelete($cat_id)
    {


        $model =  $this->findModel($cat_id);
        $model->cat_estado = Parametros::ELIMINADO;
        $model->save();

        return $this->redirect(['index']);
    }

    /**
     * Finds the Categorias model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param int $cat_id Cat ID
     * @return Categorias the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($cat_id)
    {
        if (($model = Categorias::findOne(['cat_id' => $cat_id])) !== null) {
            return $model;
        }

        throw new NotFoundHttpException('The requested page does not exist.');
    }
}
