<?php

namespace app\controllers;

use app\models\Detalleseparados;
use app\models\DetalleseparadosSearch;
use app\models\Facturas;
use app\models\Parametros;
use stdClass;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;

/**
 * DetalleseparadosController implements the CRUD actions for Detalleseparados model.
 */
class DetalleseparadosController extends Controller
{
    /**
     * @inheritDoc
     */
    public function behaviors()
    {
        return array_merge(
            parent::behaviors(),
            [
                'verbs' => [
                    'class' => VerbFilter::className(),
                    'actions' => [
                        'delete' => ['POST'],
                    ],
                ],
            ]
        );
    }

    /**
     * Lists all Detalleseparados models.
     *
     * @return string
     */
    public function actionIndex()
    {
        $searchModel = new DetalleseparadosSearch();
        $dataProvider = $searchModel->search($this->request->queryParams);

        return $this->render('index', [
            'searchModel' => $searchModel,
            'dataProvider' => $dataProvider,
        ]);
    }

    /**
     * Displays a single Detalleseparados model.
     * @param int $det_id Det ID
     * @return string
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionView($det_id)
    {
        return $this->render('view', [
            'model' => $this->findModel($det_id),
        ]);
    }

    /**
     * Creates a new Detalleseparados model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     * @return string|\yii\web\Response
     */
    public function actionCreate()
    {
        $model = new Detalleseparados();

        if ($this->request->isPost) {
            if ($model->load($this->request->post()) && $model->save()) {
                return $this->redirect(['view', 'det_id' => $model->det_id]);
            }
        } else {
            $model->loadDefaultValues();
        }

        return $this->render('create', [
            'model' => $model,
        ]);
    }

    /**
     * Updates an existing Detalleseparados model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param int $det_id Det ID
     * @return string|\yii\web\Response
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionUpdate($det_id)
    {
        $model = $this->findModel($det_id);

        if ($this->request->isPost && $model->load($this->request->post()) && $model->save()) {
            return $this->redirect(['view', 'det_id' => $model->det_id]);
        }

        return $this->render('update', [
            'model' => $model,
        ]);
    }

    /**
     * Deletes an existing Detalleseparados model.
     * If deletion is successful, the browser will be redirected to the 'index' page.
     * @param int $det_id Det ID
     * @return \yii\web\Response
     * @throws NotFoundHttpException if the model cannot be found
     */


    public function actionAbonar($factura, $monto)
    {


        $resultado = new \stdClass();
        $resultado->transaccion = false;
        $resultado->facturar = false;

        date_default_timezone_set('America/Guayaquil'); //1:::HORA DE GUAYAQUIL

        $facturaAct = Facturas::find()->where(['fac_id' => $factura])->one();


        if ($monto > $facturaAct->fac_saldo) {
            $resultado->error = 'El monto ingresado excede al monto pendiente';
            return json_encode($resultado);
        }

        $detalleSeparado = new Detalleseparados();
        $detalleSeparado->fecha = date('Y-m-d H:i:s');
        $detalleSeparado->fac_id = $factura;
        $detalleSeparado->monto = $monto;
        $detalleSeparado->saldo = $facturaAct->fac_saldo - $monto;

        $facturaAct->fac_saldo =  $facturaAct->fac_saldo - $monto;

        if ($facturaAct->fac_saldo == 0) {
            $resultado->facturar = true;
            $facturaAct->fac_tipo = Parametros::NOTA_PEDIDO;
        }

        if ($facturaAct->save($facturaAct->fac_saldo) && $detalleSeparado->save()) {
            $resultado->transaccion = true;
        }

        return json_encode($resultado);
    }

    public function actionDelete($det_id)
    {
        $this->findModel($det_id)->delete();

        return $this->redirect(['index']);
    }

    /**
     * Finds the Detalleseparados model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param int $det_id Det ID
     * @return Detalleseparados the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($det_id)
    {
        if (($model = Detalleseparados::findOne(['det_id' => $det_id])) !== null) {
            return $model;
        }

        throw new NotFoundHttpException('The requested page does not exist.');
    }
}
