<?php

namespace app\controllers;

use app\models\Empresa;
use app\models\EmpresaSearch;
use app\models\Parametros;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;
use yii\web\UploadedFile;
use Yii;

/**
 * EmpresaController implements the CRUD actions for Empresa model.
 */
class EmpresaController extends Controller
{
    /**
     * @inheritDoc
     */
    public function behaviors()
    {
        return array_merge(
            parent::behaviors(),
            [
                'verbs' => [
                    'class' => VerbFilter::className(),
                    'actions' => [
                        'delete' => ['POST'],
                    ],
                ],
            ]
        );
    }


    public function beforeAction($action)
    {
        if ($action->id === 'index' ||  $action->id === 'create' ||  $action->id === 'view' ||  $action->id === 'update' ||  $action->id === 'delete') {
            if (Yii::$app->user->isGuest) {
                return $this->redirect(['site/access-denied']);
            }
        }

        if (Yii::$app->user->isGuest) {
            return $this->redirect(['site/access-denied']);
        }

        return parent::beforeAction($action);
    }

    /**
     * Lists all Empresa models.
     *
     * @return string
     */
    public function actionIndex()
    {
        $this->layout = 'dashboard';
        $searchModel = new EmpresaSearch();
        $dataProvider = $searchModel->search($this->request->queryParams);

        return $this->render('index', [
            'searchModel' => $searchModel,
            'dataProvider' => $dataProvider,
        ]);
    }

    /**
     * Displays a single Empresa model.
     * @param string $codigo Codigo
     * @return string
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionView($codigo)
    {
        $this->layout = 'dashboard';
        return $this->render('view', [
            'model' => $this->findModel($codigo),
        ]);
    }

    /**
     * Creates a new Empresa model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     * @return string|\yii\web\Response
     */
    public function actionCreate()
    {
        $this->layout = 'dashboard';
        $model = new Empresa();

        if ($this->request->isPost) {
            if ($model->load($this->request->post()) && $model->save()) {
                return $this->redirect(['view', 'codigo' => $model->codigo]);
            }
        } else {
            $model->loadDefaultValues();
        }

        return $this->render('create', [
            'model' => $model,
        ]);
    }

    /**
     * Updates an existing Empresa model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param string $codigo Codigo
     * @return string|\yii\web\Response
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionUpdate()
    {
        $this->layout = 'dashboard';
        $model = $this->findModel(Parametros::empresa);

        // Guardamos los nombres actuales de las imágenes antes de cargar el post
        $oldLogotipo = $model->logotipo;
        $oldBanner = $model->imagen_banner;
        $oldMarcas = $model->marcas;
        $oldMapa = $model->mapa;

        if ($model->load(Yii::$app->request->post())) {

            // LOGOTIPO
            $logotipo = UploadedFile::getInstance($model, 'logotipo');
            if (!is_null($logotipo)) {
                $namePartsLogotipo = explode(".", $logotipo->name);
                $ext = end($namePartsLogotipo);
                $model->logotipo = Yii::$app->security->generateRandomString() . ".{$ext}";
                Yii::$app->params['uploadPath'] = Yii::$app->basePath . '/web/uploads/images/';
                $path = Yii::$app->params['uploadPath'] . $model->logotipo;
                $logotipo->saveAs($path);
            } else {
                // Si no se sube una nueva imagen, mantener el valor anterior
                $model->logotipo = $oldLogotipo;
            }

            // BANNER
            $banner = UploadedFile::getInstance($model, 'imagen_banner');
            if (!is_null($banner)) {
                $namePartsBanner = explode(".", $banner->name);
                $ext = end($namePartsBanner);
                $model->imagen_banner = Yii::$app->security->generateRandomString() . ".{$ext}";
                Yii::$app->params['uploadPath'] = Yii::$app->basePath . '/web/uploads/images/';
                $path = Yii::$app->params['uploadPath'] . $model->imagen_banner;
                $banner->saveAs($path);
            } else {
                $model->imagen_banner = $oldBanner;
            }

            // MARCAS
            $marcas = UploadedFile::getInstance($model, 'marcas');
            if (!is_null($marcas)) {
                $namePartsMarcas = explode(".", $marcas->name); // Cambié $banner->name por $marcas->name
                $ext = end($namePartsMarcas);
                $model->marcas = Yii::$app->security->generateRandomString() . ".{$ext}";
                Yii::$app->params['uploadPath'] = Yii::$app->basePath . '/web/uploads/images/';
                $path = Yii::$app->params['uploadPath'] . $model->marcas;
                $marcas->saveAs($path);
            } else {
                $model->marcas = $oldMarcas;
            }

            // MAPA
            $mapa = UploadedFile::getInstance($model, 'mapa');
            if (!is_null($mapa)) {
                $namePartsMapa = explode(".", $mapa->name); // Cambié $banner->name por $mapa->name
                $ext = end($namePartsMapa);
                $model->mapa = Yii::$app->security->generateRandomString() . ".{$ext}";
                Yii::$app->params['uploadPath'] = Yii::$app->basePath . '/web/uploads/images/';
                $path = Yii::$app->params['uploadPath'] . $model->mapa;
                $mapa->saveAs($path);
            } else {
                $model->mapa = $oldMapa;
            }

            // Guardar el modelo
            if ($model->save()) {
                return $this->redirect(['view', 'codigo' => $model->codigo]);
            } else {
                $model->loadDefaultValues();
                var_dump($model->getErrors());
                die();
            }
        }
        return $this->render('update', [
            'model' => $model,
        ]);
    }


    /**
     * Deletes an existing Empresa model.
     * If deletion is successful, the browser will be redirected to the 'index' page.
     * @param string $codigo Codigo
     * @return \yii\web\Response
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionDelete($codigo)
    {
        $this->findModel($codigo)->delete();

        return $this->redirect(['index']);
    }

    /**
     * Finds the Empresa model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param string $codigo Codigo
     * @return Empresa the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($codigo)
    {
        if (($model = Empresa::findOne(['codigo' => $codigo])) !== null) {
            return $model;
        }

        throw new NotFoundHttpException('The requested page does not exist.');
    }
}
