<?php

namespace app\controllers;

use app\models\Gastos;
use app\models\GastosSearch;
use app\models\Parametros;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;
use Yii;

/**
 * GastosController implements the CRUD actions for Gastos model.
 */
class GastosController extends Controller
{
    /**
     * @inheritDoc
     */
    public function behaviors()
    {
        return array_merge(
            parent::behaviors(),
            [
                'verbs' => [
                    'class' => VerbFilter::className(),
                    'actions' => [
                        'delete' => ['POST'],
                    ],
                ],
            ]
        );
    }



    public function beforeAction($action)
    {
        $userModel = Yii::$app->user->identity;
        if (
            $action->id === 'index'
            || $action->id === 'update'
            || $action->id === 'create'
            || $action->id === 'delete'
        ) {
            //Si no esta logueado O no es de tipo admin redirige
            if (Yii::$app->user->isGuest) {
                return $this->redirect(['site/login']);
            } else if ($userModel->rol !== 'superAdmin' && $userModel->rol !== 'vendedor') {
                return $this->redirect(['site/access-denied']);
            }
        }

        return parent::beforeAction($action);
    }




    /**
     * Lists all Gastos models.
     *
     * @return string
     */
    public function actionIndex()
    {
        $this->layout = 'dashboard';
        $searchModel = new GastosSearch();
        $dataProvider = $searchModel->search($this->request->queryParams);

        $total = 0;
        $models = $dataProvider->getModels();

        foreach ($models as $model) {
            if ($model->gas_estado == Parametros::ACTIVO) {
                $total = $total + $model->gas_valor;
            }
        }

        return $this->render('index', [
            'searchModel' => $searchModel,
            'dataProvider' => $dataProvider,
            'total' => $total
        ]);
    }

    /**
     * Displays a single Gastos model.
     * @param int $gas_id Gas ID
     * @return string
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionView($gas_id)
    {

        $this->layout = 'dashboard';
        return $this->render('view', [
            'model' => $this->findModel($gas_id),
        ]);
    }

    /**
     * Creates a new Gastos model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     * @return string|\yii\web\Response
     */
    public function actionCreate()
    {
        date_default_timezone_set('America/Guayaquil'); //1:::HORA DE GUAYAQUIL
        $this->layout = 'dashboard';
        $model = new Gastos();

        if ($this->request->isPost) {

            $model->created_by = Yii::$app->user->id;
            $model->updated_by = Yii::$app->user->id;
            $model->created_at = date('Y-m-d H:i:s');
            $model->updated_at = date('Y-m-d H:i:s');
            $model->gas_fecha = Yii::$app->request->post('gas_fecha');


            if ($model->load($this->request->post()) && $model->save()) {
                return $this->redirect(['index']);
            }
        } else {
            $model->loadDefaultValues();
        }

        return $this->render('create', [
            'model' => $model,
        ]);
    }

    /**
     * Updates an existing Gastos model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param int $gas_id Gas ID
     * @return string|\yii\web\Response
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionUpdate($gas_id)
    {
        date_default_timezone_set('America/Guayaquil'); //1:::HORA DE GUAYAQUIL
        $this->layout = 'dashboard';
        $model = $this->findModel($gas_id);

        $model->updated_by = Yii::$app->user->id;
        $model->updated_at = date('Y-m-d H:i:s');

        if ($this->request->isPost && $model->load($this->request->post()) && $model->save()) {
            return $this->redirect(['view', 'gas_id' => $model->gas_id]);
        }

        return $this->render('update', [
            'model' => $model,
        ]);
    }

    /**
     * Deletes an existing Gastos model.
     * If deletion is successful, the browser will be redirected to the 'index' page.
     * @param int $gas_id Gas ID
     * @return \yii\web\Response
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionDelete($gas_id)
    {

        $model =  $this->findModel($gas_id);
        $model->gas_estado = Parametros::ELIMINADO;
        $model->save();

        return $this->redirect(['index']);
    }

    /**
     * Finds the Gastos model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param int $gas_id Gas ID
     * @return Gastos the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($gas_id)
    {
        if (($model = Gastos::findOne(['gas_id' => $gas_id])) !== null) {
            return $model;
        }

        throw new NotFoundHttpException('The requested page does not exist.');
    }
}
