<?php

namespace app\controllers;

use app\models\Marcas;
use app\models\MarcasSearch;
use app\models\Parametros;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;
use Yii;

/**
 * MarcasController implements the CRUD actions for Marcas model.
 */
class MarcasController extends Controller
{
    /**
     * @inheritDoc
     */
    public function behaviors()
    {
        return array_merge(
            parent::behaviors(),
            [
                'verbs' => [
                    'class' => VerbFilter::className(),
                    'actions' => [
                        'delete' => ['POST'],
                    ],
                ],
            ]
        );
    }


    public function beforeAction($action)
    {
        $userModel = Yii::$app->user->identity;

        // Redirige si el usuario no está logueado
        if (Yii::$app->user->isGuest) {
            return $this->redirect(['site/login']);
        }

        // Redirige si el usuario no es superAdmin para las acciones update, create, delete
        if (in_array($action->id, ['update', 'create', 'delete'])) {
            if ($userModel->rol !== 'superAdmin') {
                return $this->redirect(['site/access-denied']);
            }
        }

        // Redirige si el usuario no es superAdmin ni vendedor para la acción index
        if ($action->id === 'index') {
            if (!in_array($userModel->rol, ['superAdmin', 'vendedor'])) {
                return $this->redirect(['site/access-denied']);
            }
        }

        return parent::beforeAction($action);
    }

    /**
     * Lists all Marcas models.
     *
     * @return string
     */
    public function actionIndex()
    {
        $this->layout = 'dashboard';
        $searchModel = new MarcasSearch();
        $dataProvider = $searchModel->search($this->request->queryParams);

        return $this->render('index', [
            'searchModel' => $searchModel,
            'dataProvider' => $dataProvider,
        ]);
    }

    /**
     * Displays a single Marcas model.
     * @param int $mar_id Mar ID
     * @return string
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionView($mar_id)
    {
        $this->layout = 'dashboard';
        return $this->render('view', [
            'model' => $this->findModel($mar_id),
        ]);
    }

    /**
     * Creates a new Marcas model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     * @return string|\yii\web\Response
     */
    public function actionCreate()
    {
        date_default_timezone_set('America/Guayaquil'); //1:::HORA DE GUAYAQUIL
        $this->layout = 'dashboard';
        $model = new Marcas();

        if ($this->request->isPost) {

            $model->created_by = Yii::$app->user->id;
            $model->updated_by = Yii::$app->user->id;
            $model->created_at = date('Y-m-d H:i:s');
            $model->updated_at = date('Y-m-d H:i:s');


            if ($model->load($this->request->post()) && $model->save()) {
                return $this->redirect(['index']);
            }
        } else {
            $model->loadDefaultValues();
        }

        return $this->render('create', [
            'model' => $model,
        ]);
    }

    /**
     * Updates an existing Marcas model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param int $mar_id Mar ID
     * @return string|\yii\web\Response
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionUpdate($mar_id)
    {
        date_default_timezone_set('America/Guayaquil'); //1:::HORA DE GUAYAQUIL
        $this->layout = 'dashboard';
        $model = $this->findModel($mar_id);

        $model->updated_by = Yii::$app->user->id;
        $model->updated_at = date('Y-m-d H:i:s');

        if ($this->request->isPost && $model->load($this->request->post()) && $model->save()) {
            return $this->redirect(['view', 'mar_id' => $model->mar_id]);
        }

        return $this->render('update', [
            'model' => $model,
        ]);
    }

    /**
     * Deletes an existing Marcas model.
     * If deletion is successful, the browser will be redirected to the 'index' page.
     * @param int $mar_id Mar ID
     * @return \yii\web\Response
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionDelete($mar_id)
    {

        $model =  $this->findModel($mar_id);
        $model->mar_estado = Parametros::ELIMINADO;
        $model->save();

        return $this->redirect(['index']);
    }

    /**
     * Finds the Marcas model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param int $mar_id Mar ID
     * @return Marcas the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($mar_id)
    {
        if (($model = Marcas::findOne(['mar_id' => $mar_id])) !== null) {
            return $model;
        }

        throw new NotFoundHttpException('The requested page does not exist.');
    }
}
