<?php

namespace app\controllers;

use app\models\Solicitudes;
use app\models\SolicitudesSearch;
use Exception;
use stdClass;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;

/**
 * SolicitudesController implements the CRUD actions for Solicitudes model.
 */
class SolicitudesController extends Controller
{
    /**
     * @inheritDoc
     */
    public function behaviors()
    {
        return array_merge(
            parent::behaviors(),
            [
                'verbs' => [
                    'class' => VerbFilter::className(),
                    'actions' => [
                        'delete' => ['POST'],
                    ],
                ],
            ]
        );
    }

    /**
     * Lists all Solicitudes models.
     *
     * @return string
     */
    public function actionIndex()
    {
        $this->layout = 'dashboard';
        $searchModel = new SolicitudesSearch();
        $dataProvider = $searchModel->search($this->request->queryParams);

        return $this->render('index', [
            'searchModel' => $searchModel,
            'dataProvider' => $dataProvider,
        ]);
    }

    /**
     * Displays a single Solicitudes model.
     * @param int $id ID
     * @return string
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionView($id)
    {
        $this->layout = 'dashboard';
        return $this->render('view', [
            'model' => $this->findModel($id),
        ]);
    }

    /**
     * Creates a new Solicitudes model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     * @return string|\yii\web\Response
     */
    public function actionCreate()
    {
        $this->layout = 'dashboard';
        date_default_timezone_set('America/Guayaquil'); //1:::HORA DE GUAYAQUIL
        $model = new Solicitudes();

        if ($this->request->isPost) {

            $model->fecha = date('Y-m-d H:i:s');

            if ($model->load($this->request->post()) && $model->save()) {
                return $this->redirect(['view', 'id' => $model->id]);
            }
        } else {
            $model->loadDefaultValues();
        }

        return $this->render('create', [
            'model' => $model,
        ]);
    }

    /**
     * Updates an existing Solicitudes model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param int $id ID
     * @return string|\yii\web\Response
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionUpdate($id)
    {
        $this->layout = 'dashboard';
        date_default_timezone_set('America/Guayaquil'); //1:::HORA DE GUAYAQUIL
        $model = $this->findModel($id);

        if ($this->request->isPost && $model->load($this->request->post()) && $model->save()) {
            return $this->redirect(['view', 'id' => $model->id]);
        }

        return $this->render('update', [
            'model' => $model,
        ]);
    }

    /**
     * Deletes an existing Solicitudes model.
     * If deletion is successful, the browser will be redirected to the 'index' page.
     * @param int $id ID
     * @return \yii\web\Response
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionDelete($id)
    {
        date_default_timezone_set('America/Guayaquil'); //1:::HORA DE GUAYAQUIL
        $this->findModel($id)->delete();

        return $this->redirect(['index']);
    }

    /**
     * Finds the Solicitudes model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param int $id ID
     * @return Solicitudes the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($id)
    {
        if (($model = Solicitudes::findOne(['id' => $id])) !== null) {
            return $model;
        }

        throw new NotFoundHttpException('The requested page does not exist.');
    }


    public function actionIngresarSolicitud(){
        $resultado = new \stdClass;
        $resultado->transaccion = false;

        try{


            $model = new Solicitudes();
            date_default_timezone_set('America/Guayaquil'); //1:::HORA DE GUAYAQUIL

            $model->nombre = $_POST["nombre"];
            $model->dirección = $_POST["direccion"];
            $model->celular = $_POST["celular"];
            $model->comentario = $_POST["detalle"];
            $model->responsable = "0103560132";
            $model->respuesta = "";
            $model->estado = "Pendiente";

            $model->tipo = $_POST["tipo"];
            $model->fecha = date('Y-m-d H:i:s');



            if($model->save()){
                $resultado->transaccion = true;
            }else{
                $resultado->error = 'Lo sentimos, tuvimos un incoveniente. Intentalo más tarde';
                $resultado->detalle = $model->getErrors();
            }


        }catch(Exception $e){
            $resultado->error = $e->getMessage();
        }

        return json_encode($resultado) ;

    }
}
