<?php

namespace app\controllers;

use app\models\Parametros;
use app\models\Tipogastos;
use app\models\TipogastosSearch;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;
use Yii;

/**
 * TipogastosController implements the CRUD actions for Tipogastos model.
 */
class TipogastosController extends Controller
{
    /**
     * @inheritDoc
     */
    public function behaviors()
    {
        return array_merge(
            parent::behaviors(),
            [
                'verbs' => [
                    'class' => VerbFilter::className(),
                    'actions' => [
                        'delete' => ['POST'],
                    ],
                ],
            ]
        );
    }




    public function beforeAction($action)
    {
        $userModel = Yii::$app->user->identity;
        if (
            $action->id === 'index'
            || $action->id === 'update'
            || $action->id === 'create'
            || $action->id === 'delete'
        ) {
            //Si no esta logueado O no es de tipo admin redirige
            if (Yii::$app->user->isGuest) {
                return $this->redirect(['site/login']);
            } else if ($userModel->rol !== 'superAdmin' && $userModel->rol !== 'vendedor') {
                return $this->redirect(['site/access-denied']);
            }
        }

        return parent::beforeAction($action);
    }

    /**
     * Lists all Tipogastos models.
     *
     * @return string
     */
    public function actionIndex()
    {
        $this->layout = 'dashboard';
        $searchModel = new TipogastosSearch();
        $dataProvider = $searchModel->search($this->request->queryParams);

        return $this->render('index', [
            'searchModel' => $searchModel,
            'dataProvider' => $dataProvider,
        ]);
    }

    /**
     * Displays a single Tipogastos model.
     * @param int $tip_gasto_id Tip Gasto ID
     * @return string
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionView($tip_gasto_id)
    {
        $this->layout = 'dashboard';
        return $this->render('view', [
            'model' => $this->findModel($tip_gasto_id),
        ]);
    }

    /**
     * Creates a new Tipogastos model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     * @return string|\yii\web\Response
     */
    public function actionCreate()
    {
        date_default_timezone_set('America/Guayaquil'); //1:::HORA DE GUAYAQUIL
        $this->layout = 'dashboard';
        $model = new Tipogastos();

        if ($this->request->isPost) {

            $model->created_by = Yii::$app->user->id;
            $model->updated_by = Yii::$app->user->id;
            $model->created_at = date('Y-m-d H:i:s');
            $model->updated_at = date('Y-m-d H:i:s');


            if ($model->load($this->request->post()) && $model->save()) {
                return $this->redirect(['index']);
            }
        } else {
            $model->loadDefaultValues();
        }

        return $this->render('create', [
            'model' => $model,
        ]);
    }

    /**
     * Updates an existing Tipogastos model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param int $tip_gasto_id Tip Gasto ID
     * @return string|\yii\web\Response
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionUpdate($tip_gasto_id)
    {
        date_default_timezone_set('America/Guayaquil'); //1:::HORA DE GUAYAQUIL
        $this->layout = 'dashboard';
        $model = $this->findModel($tip_gasto_id);

        $model->updated_by = Yii::$app->user->id;
        $model->updated_at = date('Y-m-d H:i:s');

        if ($this->request->isPost && $model->load($this->request->post()) && $model->save()) {
            return $this->redirect(['view', 'tip_gasto_id' => $model->tip_gasto_id]);
        }

        return $this->render('update', [
            'model' => $model,
        ]);
    }

    /**
     * Deletes an existing Tipogastos model.
     * If deletion is successful, the browser will be redirected to the 'index' page.
     * @param int $tip_gasto_id Tip Gasto ID
     * @return \yii\web\Response
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionDelete($tip_gasto_id)
    {

        $model =  $this->findModel($tip_gasto_id);
        $model->tip_estado = Parametros::ELIMINADO;
        $model->save();

        return $this->redirect(['index']);
    }

    /**
     * Finds the Tipogastos model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param int $tip_gasto_id Tip Gasto ID
     * @return Tipogastos the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($tip_gasto_id)
    {
        if (($model = Tipogastos::findOne(['tip_gasto_id' => $tip_gasto_id])) !== null) {
            return $model;
        }

        throw new NotFoundHttpException('The requested page does not exist.');
    }
}
