<?php

namespace app\controllers;

use app\models\Parametros;
use app\models\Usuarios;
use app\models\UsuariosSearch;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;
use Yii;
use yii\web\UploadedFile;


class UsuariosController extends Controller
{
    /**
     * @inheritDoc
     */
    public function behaviors()
    {
        return array_merge(
            parent::behaviors(),
            [
                'verbs' => [
                    'class' => VerbFilter::className(),
                    'actions' => [
                        'delete' => ['POST'],
                    ],
                ],
            ]
        );
    }


    public function beforeAction($action)
    {
        $userModel = Yii::$app->user->identity;
        if (
            $action->id === 'index'
            || $action->id === 'update'
            || $action->id === 'create'
            || $action->id === 'delete'
            || $action->id === 'view'
        ) {
            //Si no esta logueado O no es de tipo admin redirige
            if (Yii::$app->user->isGuests || $userModel->rol !== 'admin') {
                return $this->redirect(['site/access-denied']);
            }
        }

        return parent::beforeAction($action);
    }

    /**
     * Lists all Carreras models.
     *
     * @return string
     */
    public function actionIndex()
    {
        $this->layout = 'dashboard';
        $searchModel = new UsuariosSearch();
        $dataProvider = $searchModel->search($this->request->queryParams);

        return $this->render('index', [
            'searchModel' => $searchModel,
            'dataProvider' => $dataProvider,
        ]);
    }

    /**
     * Displays a single Carreras model.
     * @param string $codigo Codigo
     * @return string
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionView($codigo)
    {
        $this->layout = 'dashboard';
        return $this->render('view', [
            'model' => $this->findModel($codigo),
        ]);
    }

    /**
     * Creates a new Carreras model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     * @return string|\yii\web\Response
     */
    public function actionCreate()
    {
        $model = new Carreras();
        $this->layout = 'dashboard';

        if ($model->load(Yii::$app->request->post())) {
            $imageTarjeta = UploadedFile::getInstance($model, 'img_tarjeta');
            $imageBanner = UploadedFile::getInstance($model, 'img_banner');
            $imageDirector = UploadedFile::getInstance($model, 'img_director');
            $pdfMalla = UploadedFile::getInstance($model, 'pdf_malla');

            $namePartsTarjeta = explode(".", $imageTarjeta->name);
            $namePartsBanner = explode(".", $imageBanner->name);
            $namePartsDirector = explode(".", $imageDirector->name);
            $namePartsPdfMalla = explode(".", $pdfMalla->name);

            if (!is_null($imageTarjeta)) {
                $ext = end($namePartsTarjeta);
                $model->img_tarjeta = Yii::$app->security->generateRandomString() . ".{$ext}";
                Yii::$app->params['uploadPath'] = Yii::$app->basePath . '/web/uploads/images/';
                $path = Yii::$app->params['uploadPath'] . $model->img_tarjeta;
                $imageTarjeta->saveAs($path);
            }


            if (!is_null($imageBanner)) {
                $ext = end($namePartsBanner);
                $model->img_banner = Yii::$app->security->generateRandomString() . ".{$ext}";
                Yii::$app->params['uploadPath'] = Yii::$app->basePath . '/web/uploads/images/';
                $path = Yii::$app->params['uploadPath'] . $model->img_banner;
                $imageBanner->saveAs($path);
            }


            if (!is_null($imageDirector)) {
                $ext = end($namePartsDirector);
                $model->img_director = Yii::$app->security->generateRandomString() . ".{$ext}";
                Yii::$app->params['uploadPath'] = Yii::$app->basePath . '/web/uploads/images/';
                $path = Yii::$app->params['uploadPath'] . $model->img_director;
                $imageDirector->saveAs($path);
            }


            if (!is_null($pdfMalla)) {
                $ext = end($namePartsPdfMalla);
                $model->pdf_malla = Yii::$app->security->generateRandomString() . ".{$ext}";
                Yii::$app->params['uploadPath'] = Yii::$app->basePath . '/web/uploads/images/';
                $path = Yii::$app->params['uploadPath'] . $model->pdf_malla;
                $pdfMalla->saveAs($path);
            }


            if ($model->save()) {
                return $this->redirect(['view', 'codigo' => $model->codigo]);
            } else {
                var_dump($model->getErrors());
                die();
            }
        }
        return $this->render('create', [
            'model' => $model,
        ]);
    }

    /**
     * Updates an existing Carreras model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param string $codigo Codigo
     * @return string|\yii\web\Response
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionUpdate($codigo)
    {
        $this->layout = 'dashboard';
        $model = $this->findModel($codigo);

        if ($this->request->isPost && $model->load($this->request->post()) && $model->save()) {
            return $this->redirect(['view', 'codigo' => $model->codigo]);
        }

        return $this->render('update', [
            'model' => $model,
        ]);
    }

    /**
     * Deletes an existing Carreras model.
     * If deletion is successful, the browser will be redirected to the 'index' page.
     * @param string $codigo Codigo
     * @return \yii\web\Response
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionDelete($codigo)
    {
        $this->findModel($codigo)->delete();

        $model =  $this->findModel($codigo);
        $model->estado = Parametros::ELIMINADO;
        $model->save();

        return $this->redirect(['index']);
    }

    /**
     * Finds the Carreras model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param string $codigo Codigo
     * @return Carreras the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($codigo)
    {
        if (($model = Carreras::findOne(['codigo' => $codigo])) !== null) {
            return $model;
        }

        throw new NotFoundHttpException('The requested page does not exist.');
    }


    public function actionVerCarrera($codigo)
    {
        return $this->render('view_carrera', [
            'model' => $this->findModel($codigo),
        ]);
    }
}
