<?php

namespace app\controllers;

use app\models\Detallefacturas;
use app\models\Facturas;
use app\models\Parametros;
use app\models\Productos;
use app\models\ProductosSearch;
use app\models\User;
use Exception;
use SebastianBergmann\CodeCoverage\Report\Xml\Totals;
use stdClass;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;
use Yii;
use yii\web\UploadedFile;

/**
 * ProductosController implements the CRUD actions for Productos model.
 */
class ValoresController extends Controller
{

    public function behaviors()
    {
        return array_merge(
            parent::behaviors(),
            [
                'verbs' => [
                    'class' => VerbFilter::className(),
                    'actions' => [
                        'delete' => ['POST'],
                    ],
                ],
            ]
        );
    }




    public function actionCuadrarValores()
    {
        date_default_timezone_set('America/Guayaquil');
        $this->layout = 'dashboard';
        return $this->render('valores');
    }



    public function actionConsultaValores($fecha)
    {

        $resultado = new \stdClass();
        $resultado->transaccion = false;

        $totalFacturaEfectivo = 0;
        $totalFacturaTarjeta = 0;
        $totalFacturaTransferencia = 0;
        $totalCosto = 0;
        $totalGanancia = 0;
        $porcGanacia = 0;


        if (empty($fecha)) {
            $fecha = date('Y-m-d'); // Fecha actual en formato YYYY-MM-DD
        }

        $facturas = Facturas::find()
            ->where(['DATE(fac_fecha)' => $fecha])->all();
        

        foreach ($facturas as $factura) {
            
            if ($factura->fac_metodo_pago_id == Parametros::TARJETA) {
                $totalFacturaTarjeta = $totalFacturaTarjeta + $factura->fac_total;
            } else  if ($factura->fac_metodo_pago_id == Parametros::TRANSFERENCIA) {
                $totalFacturaTransferencia = $totalFacturaTransferencia + $factura->fac_total;
            } else {
                $totalFacturaEfectivo = $totalFacturaEfectivo + $factura->fac_total;
            }


            $detalles = Detallefacturas::find()->where(['fac_id' => $factura->fac_id, 'det_estado' => Parametros::ACTIVO])->all();

            foreach ($detalles as $detalle) {
                $prodDetalle = Productos::find()->where(['pro_codigo'=>$detalle->pro_codigo])->select(['pro_costo'])->one();
                $totalCosto = $totalCosto + $prodDetalle->pro_costo;
            }
        }

        $totalGanancia = ($totalFacturaEfectivo + $totalFacturaTransferencia + $totalFacturaTarjeta) - $totalCosto;

        $resultado->totalFacturas = round($totalFacturaEfectivo + $totalFacturaTransferencia + $totalFacturaTarjeta, 2) ;
        $resultado->totalFacturaEfectivo = round($totalFacturaEfectivo, 2);
        $resultado->totalFacturaTarjeta = $totalFacturaTarjeta;
        $resultado->totalFacturaTransferencia = $totalFacturaTransferencia;
        $resultado->totalCosto =  number_format($totalCosto,2) ;
        $resultado->totalGanancia =  number_format($totalGanancia, 2) ;
        $resultado->transaccion = true;


        return json_encode($resultado);
    }
}
