<?php

namespace app\models;

use Yii;

/**
 * This is the model class for table "empresa".
 *
 * @property string $codigo
 * @property string $nombre
 * @property string $descripcion_banner
 * @property string $imagen_banner
 * @property string $nosotros
 * @property string $horario_atencion
 * @property string $telefonos
 * @property string $logotipo
 * @property string $marcas
 * @property string $whatsapp
 * @property string $facebook
 * @property string $direccion
 * @property string $mapa
 * @property string $googlemaps
 */
class Empresa extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'empresa';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['codigo', 'nombre'], 'required'],
            [['descripcion_banner', 'nosotros', 'googlemaps'], 'string'],
            [['codigo', 'whatsapp'], 'string', 'max' => 20],
            [['nombre', 'telefonos', 'facebook'], 'string', 'max' => 200],
            [['imagen_banner', 'horario_atencion'], 'string', 'max' => 400],
            [['marcas', 'logotipo'], 'string', 'max' => 300],
            [['direccion'], 'string', 'max' => 300],
            [['mapa'], 'string', 'max' => 300],
            [['venta', 'mantenimiento', 'reparacion'], 'string', 'max' => 500],
            [['codigo'], 'unique'],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'codigo' => 'Codigo',
            'nombre' => 'Nombre',
            'descripcion_banner' => 'Descripcion Banner',
            'imagen_banner' => 'Imagen Banner',
            'nosotros' => 'Nosotros',
            'horario_atencion' => 'Horario Atencion',
            'telefonos' => 'Telefonos',
            'logotipo' => 'Logotipo',
            'marcas' => 'Marcas',
            'whatsapp' => 'Whatsapp',
            'facebook' => 'Facebook',
            'direccion' => 'Direccion',
            'mapa' => 'Mapa',
            'googlemaps' => 'Googlemaps',
        ];
    }
}
