<?php

namespace app\models;

use yii\base\Model;
use yii\data\ActiveDataProvider;
use app\models\Empresa;

/**
 * EmpresaSearch represents the model behind the search form of `app\models\Empresa`.
 */
class EmpresaSearch extends Empresa
{
    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['codigo', 'nombre', 'descripcion_banner', 'imagen_banner', 'nosotros', 'horario_atencion', 'telefonos', 'logotipo', 'marcas', 'whatsapp', 'facebook', 'direccion', 'mapa', 'googlemaps', 'venta', 'mantenimiento', 'reparacion'], 'safe'],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function scenarios()
    {
        // bypass scenarios() implementation in the parent class
        return Model::scenarios();
    }

    /**
     * Creates data provider instance with search query applied
     *
     * @param array $params
     *
     * @return ActiveDataProvider
     */
    public function search($params)
    {
        $query = Empresa::find();

        // add conditions that should always apply here

        $dataProvider = new ActiveDataProvider([
            'query' => $query,
        ]);

        $this->load($params);

        if (!$this->validate()) {
            // uncomment the following line if you do not want to return any records when validation fails
            // $query->where('0=1');
            return $dataProvider;
        }

        // grid filtering conditions
        $query->andFilterWhere(['like', 'codigo', $this->codigo])
            ->andFilterWhere(['like', 'nombre', $this->nombre])
            ->andFilterWhere(['like', 'descripcion_banner', $this->descripcion_banner])
            ->andFilterWhere(['like', 'imagen_banner', $this->imagen_banner])
            ->andFilterWhere(['like', 'nosotros', $this->nosotros])
            ->andFilterWhere(['like', 'horario_atencion', $this->horario_atencion])
            ->andFilterWhere(['like', 'telefonos', $this->telefonos])
            ->andFilterWhere(['like', 'logotipo', $this->logotipo])
            ->andFilterWhere(['like', 'marcas', $this->marcas])
            ->andFilterWhere(['like', 'whatsapp', $this->whatsapp])
            ->andFilterWhere(['like', 'facebook', $this->facebook])
            ->andFilterWhere(['like', 'direccion', $this->direccion])
            ->andFilterWhere(['like', 'mapa', $this->mapa])
            ->andFilterWhere(['like', 'googlemaps', $this->googlemaps]);

        return $dataProvider;
    }
}
