<?php

namespace app\models;

use Yii;

/**
 * This is the model class for table "gastos".
 *
 * @property int $gas_id
 * @property string $gas_fecha
 * @property int $gas_descripcion
 * @property int $gas_tipo
 * @property float $gas_valor
 * @property string $created_at
 * @property string $updated_at
 * @property int $created_by
 * @property int $updated_by
 */
class Gastos extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'gastos';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['gas_fecha', 'gas_descripcion', 'gas_tipo', 'gas_valor', 'created_at', 'updated_at', 'created_by', 'updated_by', 'gas_estado'], 'required'],
            [['gas_fecha', 'created_at', 'updated_at'], 'safe'],
            [['gas_tipo', 'created_by', 'updated_by'], 'integer'],
            [['gas_valor'], 'match', 'pattern' => '/^\d+(\.\d{1,2})?$/', 'message' => 'El valor debe ser un número con máximo dos decimales.']
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'gas_id' => 'Gas ID',
            'gas_fecha' => 'Fecha',
            'gas_descripcion' => 'Descripción',
            'gas_tipo' => 'Tipo',
            'gas_valor' => 'Valor',
            'gas_estado' => 'Estado',
            'created_at' => 'Fecha creación',
            'updated_at' => 'Fecha actualización',
            'created_by' => 'Creado por',
            'updated_by' => 'Actualizado por',
        ];
    }
}
