<?php

namespace app\models;

use yii\base\Model;
use yii\data\ActiveDataProvider;
use app\models\Gastos;

/**
 * GastosSearch represents the model behind the search form of `app\models\Gastos`.
 */
class GastosSearch extends Gastos
{
    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['gas_id', 'gas_descripcion', 'gas_tipo', 'created_by', 'updated_by'], 'integer'],
            [['gas_fecha', 'created_at', 'updated_at', 'gas_estado'], 'safe'],
            [['gas_valor'], 'number'],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function scenarios()
    {
        // bypass scenarios() implementation in the parent class
        return Model::scenarios();
    }

    /**
     * Creates data provider instance with search query applied
     *
     * @param array $params
     *
     * @return ActiveDataProvider
     */
    public function search($params)
    {
        $query = Gastos::find();

        // add conditions that should always apply here

        $dataProvider = new ActiveDataProvider([
            'query' => $query,
        ]);

        $this->load($params);

        if (!$this->validate()) {
            // uncomment the following line if you do not want to return any records when validation fails
            // $query->where('0=1');
            return $dataProvider;
        }

        // grid filtering conditions
        $query->andFilterWhere([
            'gas_id' => $this->gas_id,
            'gas_fecha' => $this->gas_fecha,
            'gas_descripcion' => $this->gas_descripcion,
            'gas_tipo' => $this->gas_tipo,
            'gas_valor' => $this->gas_valor,
            'created_at' => $this->created_at,
            'updated_at' => $this->updated_at,
            'created_by' => $this->created_by,
            'updated_by' => $this->updated_by,
            'gas_estado' => Parametros::ESTADOS_VALIDOS,
        ]);

        return $dataProvider;
    }
}
