<?php

namespace app\models;

use Yii;

/**
 * This is the model class for table "institutos".
 *
 * @property int $id_instituto
 * @property string $nombre_instituto
 * @property string|null $codigo
 * @property int|null $created_by
 * @property int|null $updated_by
 * @property string|null $created_at
 * @property string|null $updated_at
 */
class Institutos extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'institutos';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['nombre_instituto'], 'required'],
            [['created_by', 'updated_by'],  'string', 'max' => 10],
            [['created_at', 'updated_at'], 'safe'],
            [['nombre_instituto'], 'string', 'max' => 100],
            [['codigo'], 'string', 'max' => 10],
            [['codigo'], 'unique'],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id_instituto' => 'Id Instituto',
            'nombre_instituto' => 'Nombre Instituto',
            'codigo' => 'Codigo',
            'created_by' => 'Created By',
            'updated_by' => 'Updated By',
            'created_at' => 'Created At',
            'updated_at' => 'Updated At',
        ];
    }
}
