<?php

namespace app\models;

use Yii;

/**
 * This is the model class for table "jornadas".
 *
 * @property int $id_jornada
 * @property string $nombre_jornada
 * @property int|null $created_by
 * @property int|null $updated_by
 * @property string|null $created_at
 * @property string|null $updated_at
 */
class Jornadas extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'jornadas';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['nombre_jornada', 'codigo'], 'required'],
            [['id_instituto'], 'integer'],
            [['created_by', 'codigo', 'updated_by'],  'string', 'max' => 10],
            [['created_at', 'updated_at'], 'safe'],
            [['nombre_jornada'], 'string', 'max' => 50],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id_jornada' => 'Id Jornada',
            'nombre_jornada' => 'Nombre Jornada',
            'created_by' => 'Created By',
            'updated_by' => 'Updated By',
            'created_at' => 'Created At',
            'updated_at' => 'Updated At',
        ];
    }
}
