<?php

namespace app\models;

use yii\base\Model;
use yii\data\ActiveDataProvider;
use app\models\Marcas;

/**
 * MarcasSearch represents the model behind the search form of `app\models\Marcas`.
 */
class MarcasSearch extends Marcas
{
    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['mar_id', 'created_by', 'updated_by'], 'integer'],
            [['mar_nombre', 'mar_estado', 'created_at', 'updated_at'], 'safe'],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function scenarios()
    {
        // bypass scenarios() implementation in the parent class
        return Model::scenarios();
    }

    /**
     * Creates data provider instance with search query applied
     *
     * @param array $params
     *
     * @return ActiveDataProvider
     */
    public function search($params)
    {
        $query = Marcas::find();

        // add conditions that should always apply here

        $dataProvider = new ActiveDataProvider([
            'query' => $query,
        ]);

        $this->load($params);

        if (!$this->validate()) {
            // uncomment the following line if you do not want to return any records when validation fails
            // $query->where('0=1');
            return $dataProvider;
        }

        // grid filtering conditions
        $query->andFilterWhere([
            'mar_id' => $this->mar_id,
            'created_at' => $this->created_at,
            'updated_at' => $this->updated_at,
            'created_by' => $this->created_by,
            'updated_by' => $this->updated_by,
            'mar_estado' => Parametros::ESTADOS_VALIDOS,
        ]);

        $query->andFilterWhere(['like', 'mar_nombre', $this->mar_nombre])
            ->andFilterWhere(['like', 'mar_estado', $this->mar_estado]);

        return $dataProvider;
    }
}
