<?php

namespace app\models;

use Yii;

/**
 * This is the model class for table "materias".
 *
 * @property int $id_materia
 * @property string $nombre_materia
 * @property string|null $codigo
 * @property int|null $id_instituto
 * @property int|null $created_by
 * @property int|null $updated_by
 * @property string|null $created_at
 * @property string|null $updated_at
 */
class Materias extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'materias';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['nombre_materia'], 'required'],
            [['id_instituto'], 'integer'],
            [['created_by', 'updated_by'],  'string', 'max' => 10],
            [['created_at', 'updated_at'], 'safe'],
            [['nombre_materia'], 'string', 'max' => 50],
            [['codigo'], 'string', 'max' => 10],
            [['codigo'], 'unique'],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id_materia' => 'Id Materia',
            'nombre_materia' => 'Nombre Materia',
            'codigo' => 'Codigo',
            'id_instituto' => 'Id Instituto',
            'created_by' => 'Created By',
            'updated_by' => 'Updated By',
            'created_at' => 'Created At',
            'updated_at' => 'Updated At',
        ];
    }
}
