<?php

namespace app\models;

use yii\base\Model;
use yii\data\ActiveDataProvider;
use app\models\Metodospago;

/**
 * MetodospagoSearch represents the model behind the search form of `app\models\Metodospago`.
 */
class MetodospagoSearch extends Metodospago
{
    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['met_pago_id', 'created_by', 'updated_by'], 'integer'],
            [['met_pago_nombre', 'met_pago_estado', 'created_at', 'updated_at'], 'safe'],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function scenarios()
    {
        // bypass scenarios() implementation in the parent class
        return Model::scenarios();
    }

    /**
     * Creates data provider instance with search query applied
     *
     * @param array $params
     *
     * @return ActiveDataProvider
     */
    public function search($params)
    {
        $query = Metodospago::find();

        // add conditions that should always apply here

        $dataProvider = new ActiveDataProvider([
            'query' => $query,
        ]);

        $this->load($params);

        if (!$this->validate()) {
            // uncomment the following line if you do not want to return any records when validation fails
            // $query->where('0=1');
            return $dataProvider;
        }

        // grid filtering conditions
        $query->andFilterWhere([
            'met_pago_id' => $this->met_pago_id,
            'created_at' => $this->created_at,
            'updated_at' => $this->updated_at,
            'created_by' => $this->created_by,
            'updated_by' => $this->updated_by,
        ]);

        $query->andFilterWhere(['like', 'met_pago_nombre', $this->met_pago_nombre])
            ->andFilterWhere(['like', 'met_pago_estado', $this->met_pago_estado]);

        return $dataProvider;
    }
}
