<?php

namespace app\models;

use Yii;

/**
 * This is the model class for table "modalidades".
 *
 * @property int $id_modalidad
 * @property string $nombre_modalidad
 * @property int|null $created_by
 * @property int|null $updated_by
 * @property string|null $created_at
 * @property string|null $updated_at
 */
class Modalidades extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'modalidades';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['nombre_modalidad', 'codigo'], 'required'],
            [['id_instituto'], 'integer'],
            [['created_by', 'updated_by', 'codigo'],  'string', 'max' => 10],
            [['created_at', 'updated_at'], 'safe'],
            [['nombre_modalidad'], 'string', 'max' => 50],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id_modalidad' => 'Id Modalidad',
            'nombre_modalidad' => 'Nombre Modalidad',
            'created_by' => 'Created By',
            'updated_by' => 'Updated By',
            'created_at' => 'Created At',
            'updated_at' => 'Updated At',
        ];
    }
}
