<?php

namespace app\models;

use yii\base\Model;
use yii\data\ActiveDataProvider;
use app\models\Productos;

/**
 * ProductosSearch represents the model behind the search form of `app\models\Productos`.
 */
class ProductosSearch extends Productos
{
    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['pro_id', 'prov_id',  'cat_id', 'pro_color', 'pro_dscto', 'pro_marca', 'pro_cant_min_desct', 'pro_stock', 'created_by', 'updated_by'], 'integer'],
            [['pro_nombre', 'pro_codigo', 'pro_foto', 'pro_modelo', 'pro_descripcion', 'pro_estado', 'created_at', 'updated_at', 'prov_id', 'pro_pvp_tarjeta', 'pro_aumentar_stock', 'pro_talla'], 'safe'],
            [['pro_costo', 'pro_pvp', 'pro_porc_dscto'], 'number'],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function scenarios()
    {
        // bypass scenarios() implementation in the parent class
        return Model::scenarios();
    }

    /**
     * Creates data provider instance with search query applied
     *
     * @param array $params
     *
     * @return ActiveDataProvider
     */
    public function search($params)
    {
        $query = Productos::find();

        // add conditions that should always apply here

        $dataProvider = new ActiveDataProvider([
            'query' => $query,
        ]);

        $this->load($params);

        if (!$this->validate()) {
            // uncomment the following line if you do not want to return any records when validation fails
            // $query->where('0=1');
            return $dataProvider;
        }

        // grid filtering conditions
        $query->andFilterWhere([
            'pro_id' => $this->pro_id,
            'prov_id' => $this->prov_id,
            'pro_talla' => $this->pro_talla,
            'cat_id' => $this->cat_id,
            'pro_color' => $this->pro_color,
            'pro_costo' => $this->pro_costo,
            'pro_pvp' => $this->pro_pvp,
            'pro_dscto' => $this->pro_dscto,
            'pro_marca' => $this->pro_marca,
            'pro_cant_min_desct' => $this->pro_cant_min_desct,
            'pro_porc_dscto' => $this->pro_porc_dscto,
            'pro_stock' => $this->pro_stock,
            'created_at' => $this->created_at,
            'updated_at' => $this->updated_at,
            'created_by' => $this->created_by,
            'updated_by' => $this->updated_by,
            'pro_estado' => Parametros::ESTADOS_VALIDOS,
        ]);

        $query->andFilterWhere(['like', 'pro_nombre', $this->pro_nombre])
            ->andFilterWhere(['like', 'pro_codigo', $this->pro_codigo])
            ->andFilterWhere(['like', 'pro_foto', $this->pro_foto])
            ->andFilterWhere(['like', 'pro_modelo', $this->pro_modelo])
            ->andFilterWhere(['like', 'pro_descripcion', $this->pro_descripcion])
            ->andFilterWhere(['like', 'pro_estado', $this->pro_estado]);

        return $dataProvider;
    }
}
