<?php

namespace app\models;

use Yii;

/**
 * This is the model class for table "recursos".
 *
 * @property int $id_recurso
 * @property string $nombre_recurso
 * @property string $descripcion_recurso
 * @property int $cantidad_disponible
 * @property int|null $created_by
 * @property int|null $updated_by
 * @property string|null $created_at
 * @property string|null $updated_at
 */
class Recursos extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'recursos';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['nombre_recurso', 'descripcion_recurso', 'cantidad_disponible'], 'required'],
            [['descripcion_recurso'], 'string'],
            [['cantidad_disponible', 'created_by', 'updated_by'], 'integer'],
            [['created_at', 'updated_at'], 'safe'],
            [['nombre_recurso'], 'string', 'max' => 50],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id_recurso' => 'Id Recurso',
            'nombre_recurso' => 'Nombre Recurso',
            'descripcion_recurso' => 'Descripcion Recurso',
            'cantidad_disponible' => 'Cantidad Disponible',
            'created_by' => 'Created By',
            'updated_by' => 'Updated By',
            'created_at' => 'Created At',
            'updated_at' => 'Updated At',
        ];
    }
}
