<?php

namespace app\models;

use yii\base\Model;
use yii\data\ActiveDataProvider;
use app\models\Recursos;

/**
 * RecursosSearch represents the model behind the search form of `app\models\Recursos`.
 */
class RecursosSearch extends Recursos
{
    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['id_recurso', 'cantidad_disponible', 'created_by', 'updated_by'], 'integer'],
            [['nombre_recurso', 'descripcion_recurso', 'created_at', 'updated_at'], 'safe'],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function scenarios()
    {
        // bypass scenarios() implementation in the parent class
        return Model::scenarios();
    }

    /**
     * Creates data provider instance with search query applied
     *
     * @param array $params
     *
     * @return ActiveDataProvider
     */
    public function search($params)
    {
        $query = Recursos::find();

        // add conditions that should always apply here

        $dataProvider = new ActiveDataProvider([
            'query' => $query,
        ]);

        $this->load($params);

        if (!$this->validate()) {
            // uncomment the following line if you do not want to return any records when validation fails
            // $query->where('0=1');
            return $dataProvider;
        }

        // grid filtering conditions
        $query->andFilterWhere([
            'id_recurso' => $this->id_recurso,
            'cantidad_disponible' => $this->cantidad_disponible,
            'created_by' => $this->created_by,
            'updated_by' => $this->updated_by,
            'created_at' => $this->created_at,
            'updated_at' => $this->updated_at,
        ]);

        $query->andFilterWhere(['like', 'nombre_recurso', $this->nombre_recurso])
            ->andFilterWhere(['like', 'descripcion_recurso', $this->descripcion_recurso]);

        return $dataProvider;
    }
}
