<?php

namespace app\models;

use Yii;

/**
 * This is the model class for table "tipogastos".
 *
 * @property int $tip_gasto_id
 * @property string $tip_gasto_nombre
 * @property string $created_at
 * @property string $updated_at
 * @property int $created_by
 * @property int $updated_by
 */
class Tipogastos extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'tipogastos';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['tip_gasto_nombre', 'created_at', 'updated_at', 'created_by', 'updated_by', 'tip_estado'], 'required'],
            [['created_at', 'updated_at'], 'safe'],
            [['created_by', 'updated_by'], 'integer'],
            [['tip_gasto_nombre'], 'string', 'max' => 100],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'tip_gasto_id' => 'Tip Gasto ID',
            'tip_gasto_nombre' => 'Tipo de Gasto',
            'created_at' => 'Fecha creación',
            'updated_at' => 'Fecha actualización',
            'created_by' => 'Creado por',
            'updated_by' => 'Actualizado por',
        ];
    }
}
