<?php

namespace app\models;

use yii\base\Model;
use yii\data\ActiveDataProvider;
use app\models\Tipogastos;

/**
 * TipogastosSearch represents the model behind the search form of `app\models\Tipogastos`.
 */
class TipogastosSearch extends Tipogastos
{
    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['tip_gasto_id', 'created_by', 'updated_by'], 'integer'],
            [['tip_gasto_nombre', 'created_at', 'updated_at', 'tip_estado'], 'safe'],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function scenarios()
    {
        // bypass scenarios() implementation in the parent class
        return Model::scenarios();
    }

    /**
     * Creates data provider instance with search query applied
     *
     * @param array $params
     *
     * @return ActiveDataProvider
     */
    public function search($params)
    {
        $query = Tipogastos::find();

        // add conditions that should always apply here

        $dataProvider = new ActiveDataProvider([
            'query' => $query,
        ]);

        $this->load($params);

        if (!$this->validate()) {
            // uncomment the following line if you do not want to return any records when validation fails
            // $query->where('0=1');
            return $dataProvider;
        }

        // grid filtering conditions
        $query->andFilterWhere([
            'tip_gasto_id' => $this->tip_gasto_id,
            'created_at' => $this->created_at,
            'updated_at' => $this->updated_at,
            'created_by' => $this->created_by,
            'updated_by' => $this->updated_by,
            'tip_estado' => Parametros::ESTADOS_VALIDOS,
        ]);

        $query->andFilterWhere(['like', 'tip_gasto_nombre', $this->tip_gasto_nombre]);

        return $dataProvider;
    }
}
