<?php

namespace app\models;

use yii\db\ActiveRecord;
use yii\base\Security;
use yii\web\IdentityInterface;

class User extends ActiveRecord implements IdentityInterface
{
    public static function tableName()
    {
        return 'user';
    }

    public function rules()
    {
        return [
            [['username', 'email', 'password', 'nombre', 'rol', 'estado', 'id',  'empresa'], 'required',  'message' => 'Campo obligatorio'],
            [['username'], 'match', 'pattern' => '/^[a-zA-Z0-9]+$/', 'message' => 'Solo se permiten caracteres alfanumericos'],  //solo letras
            [['nombre'], 'match', 'pattern' => '/^[a-zA-ZáéíóúÁÉÍÓÚñÑ\s]+$/', 'message' => 'Solo se permiten letras'],  //solo letras
            [['email'], 'email', 'message' => 'Ingrese un email válido'],  //email
            [['id'], 'string', 'max' => 10],
            [['id'], 'match', 'pattern' => '/^\d+$/', 'message' => 'Solo se permiten caracteres numéricos'],  //solo numericos
            [['nombre', 'rol', 'estado', 'password', 'id'], 'string'],
            [['username', 'id', 'email'], 'unique'],
        ];
    }


    public function setPassword($password)
    {
        $security = new Security();
        $this->password = $security->generatePasswordHash($password);
    }


    public static function createPassword($password)
    {
        $security = new Security();
        return $security->generatePasswordHash($password);
    }



    public function validatePassword($password)
    {
        $security = new Security();
        return $security->validatePassword($password, $this->password);
    }

    public static function findByUsername($username)
    {
        return static::findOne(['username' => $username]);
    }

    public function getUser()
    {
        $this->_user = static::findByUsername($this->username);
        return $this->_user;
    }

    // Método para encontrar la identidad por ID
    public static function findIdentity($id)
    {
        return static::findOne($id);
    }

    // Método para encontrar la identidad por token de acceso (si es necesario)
    public static function findIdentityByAccessToken($token, $type = null)
    {
        // Implementación para buscar por token de acceso si es necesario
    }

    // Método para obtener el ID del usuario
    public function getId()
    {
        return $this->id; // Reemplaza 'id' por el atributo que representa el ID del usuario
    }

    // Método para obtener la clave de autenticación
    public function getAuthKey()
    {
        //return $this->auth_key; // Reemplaza 'auth_key' por el atributo que representa la clave de autenticación
    }

    // Método para validar la clave de autenticación
    public function validateAuthKey($authKey)
    {
        //return $this->getAuthKey() === $authKey;
    }
}
