<?php

use app\models\Colores;
use app\models\Parametros;
use app\models\User;
use yii\helpers\Html;
use yii\helpers\Url;
use yii\grid\ActionColumn;
use yii\grid\GridView;
use Yii;

/** @var yii\web\View $this */
/** @var app\models\ColoresSearch $searchModel */
/** @var yii\data\ActiveDataProvider $dataProvider */

$this->title = 'Colores';
$this->params['breadcrumbs'][] = $this->title;

$userModel = Yii::$app->user->identity;
$esAdmin = false;
if (!empty($userModel->rol) && $userModel->rol === 'superAdmin') {
    $esAdmin = true;
}


?>
<div class="colores-index">

    <h1><?= Html::encode($this->title) ?></h1>

    <?php
    if ($esAdmin) {
        echo Html::a('Crear Color', ['create'], ['class' => 'btn btn-success']);
    }
    ?>

    <?php // echo $this->render('_search', ['model' => $searchModel]); 
    ?>



    <div class="row">
        <div class="col-lg-12 mb-4 order-0">
            <div class="card">
                <div class="d-flex align-items-end row">
                    <div class="col-sm-12">
                        <div class="card-body">


                            <?= GridView::widget([
                                'dataProvider' => $dataProvider,
                                'filterModel' => $searchModel,
                                'columns' => [
                                    ['class' => 'yii\grid\SerialColumn'],

                                    //    'col_id',
                                    'col_nombre',
                                    [
                                        'attribute' => 'col_estado',
                                        'value' => function ($model) {
                                            return $model->col_estado === Parametros::ACTIVO ? 'Activo' : 'Inactivo';
                                        },
                                        'filter' => ['A' => 'Activo', 'I' => 'Inactivo'], // Opcional, para agregar el filtro en el GridView
                                    ],
                                    //'created_at',
                                    //'updated_by',
                                    //'created_by',
                                    //'updated_at',
                                    [
                                        'attribute' => 'created_by',
                                        'value' => function ($model) {
                                            $user = User::find()->where(['id' => $model->created_by])->one();
                                            return $user->nombre;
                                        },

                                    ],
                                    [
                                        'class' => ActionColumn::className(),
                                        'urlCreator' => function ($action, Colores $model, $key, $index, $column) {
                                            return Url::toRoute([$action, 'col_id' => $model->col_id]);
                                        },
                                        'visibleButtons' => [ // Configurar la visibilidad de los botones según la variable $admin
                                            'update' => function ($model, $key, $index) use ($esAdmin) {
                                                return $esAdmin; // Solo muestra el botón si $admin es true
                                            },
                                            'view' => function ($model, $key, $index) use ($esAdmin) {
                                                return $esAdmin; // Solo muestra el botón si $admin es true
                                            },
                                            'delete' => function ($model, $key, $index) use ($esAdmin) {
                                                return $esAdmin; // Solo muestra el botón si $admin es true
                                            },
                                        ],
                                        'buttons' => [
                                            'delete' => function ($url, $model, $key) {
                                                return Html::a('<i class="fas fa-trash"></i>', $url, [
                                                    'title' => Yii::t('app', 'Eliminar'), // Título del botón (opcional)
                                                    'data-confirm' => '¿Estás seguro de que deseas eliminar este elemento?', // Mensaje en español
                                                    'data-method' => 'post', // Método para eliminar
                                                    'data-pjax' => '0', // Si usas Pjax, esto previene la actualización por Ajax
                                                ]);
                                            },
                                        ],
                                    ],
                                ],
                            ]); ?>


                        </div>
                    </div>

                </div>
            </div>
        </div>
    </div>






</div>