<?php

use yii\helpers\Html;
use yii\widgets\DetailView;

/** @var yii\web\View $this */
/** @var app\models\Empresa $model */

$this->title = $model->codigo;
$this->params['breadcrumbs'][] = ['label' => 'Empresas', 'url' => ['index']];
$this->params['breadcrumbs'][] = $this->title;
\yii\web\YiiAsset::register($this);
?>
<div class="empresa-view">

    <h1><?= Html::encode($this->title) ?></h1>

    <p>
        <?= Html::a('Actualizar', ['update', 'codigo' => $model->codigo], ['class' => 'btn btn-success']) ?>
    </p>



    <div class="row">
        <div class="col-lg-12 mb-4 order-0">
            <div class="card">
                <div class="d-flex align-items-end row">
                    <div class="col-sm-12">
                        <div class="card-body">

                            <?= DetailView::widget([
                                'model' => $model,
                                'attributes' => [
                                    'codigo',
                                    'nombre',
                                    'descripcion_banner:ntext',

                                    //    'nosotros:ntext',
                                    'horario_atencion',
                                    'telefonos',


                                    'direccion',

                                ],
                            ]) ?>


                        </div>
                    </div>

                </div>
            </div>
        </div>
    </div>




</div>