<?php

use app\models\Detalleseparados;
use app\models\Metodospago;
use app\models\Parametros;
use app\models\User;
use yii\helpers\Html;
use yii\widgets\ActiveForm;
use yii\helpers\ArrayHelper;



$metodosPagos = Metodospago::find()->where(['met_pago_estado' => Parametros::ACTIVO])->all();
$arrayproveedores = ArrayHelper::map($metodosPagos, 'met_pago_id', 'met_pago_nombre');


$usuarios = User::find()->where(['estado' => Parametros::ACTIVO])->all();


$detalleSeparados = Detalleseparados::find()->where(['fac_id' => $model->fac_id])->orderBy(['det_id' => SORT_ASC])->all();


/** @var yii\web\View $this */
/** @var app\models\Facturas $model */
/** @var yii\widgets\ActiveForm $form */
?>


<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>




<div class="facturas-form">






    <div class="row">
        <div class="col-md-12">

            <div class="card mb-4">

                <div class="card-body">
                    <div>

                        <div class="row">

                            <div class="col-md-4">
                                <div class="mb-3 row">
                                    <label for="inputPassword" class="col-sm-4 col-form-label">Identificación</label>
                                    <div class="col-sm-8">
                                        <input type="text" class="form-control" id="cliIdentificacion" onkeyup="consultaIdentificacion(this)" maxlength="13" style="background-color: #e3eff3;">
                                    </div>
                                </div>
                            </div>

                            <div class="col-md-5">
                                <div class="mb-3 row">
                                    <label for="inputPassword" class="col-sm-3 col-form-label">Nombre</label>
                                    <div class="col-sm-9">
                                        <input type="text" class="form-control" id="cliNombre" onkeyup="guardaCliente()">
                                    </div>
                                </div>
                            </div>


                            <div class="col-md-3">
                                <div class="mb-3 row">
                                    <label for="inputPassword" class="col-sm-3 col-form-label">Email</label>
                                    <div class="col-sm-9">
                                        <input type="text" class="form-control" id="cliEmail" onkeyup="guardaCliente()">
                                    </div>
                                </div>
                            </div>

                        </div>

                        <div class="row">

                            <div class="col-md-6">
                                <div class="mb-3 row">
                                    <label for="inputPassword" class="col-sm-2 col-form-label">Dirección</label>
                                    <div class="col-sm-10">
                                        <input type="text" class="form-control" id="cliDireccion" onkeyup="guardaCliente()">
                                    </div>
                                </div>
                            </div>

                            <div class="col-md-3">
                                <div class="mb-3 row">
                                    <label for="inputPassword" class="col-sm-4 col-form-label">Teléfono</label>
                                    <div class="col-sm-8">
                                        <input type="text" class="form-control" id="cliFono" onkeyup="guardaCliente()" minlength="7" maxlength="15">
                                    </div>
                                </div>
                            </div>


                            <div class="col-md-3">
                                <div class="mb-3 row">
                                    <label for="inputPassword" class="col-sm-3 col-form-label">Celular</label>
                                    <div class="col-sm-9">
                                        <input type="text" class="form-control" id="cliCelular" onkeyup="guardaCliente()" minlength="10" maxlength="10">
                                    </div>
                                </div>
                            </div>

                        </div>



                        <hr>


                        <div class="row">

                            <div class="col-md-5">
                                <div class="mb-3 row">
                                    <label for="inputPassword" class="col-sm-4 col-form-label">Método de Pago</label>
                                    <div class="col-sm-8">
                                        <select name="metodoPago" id="metodoPago" class="form-control" onchange="getDetalleFactura()" style="background-color: #e1ebe1;">

                                            <option value="<?= Parametros::EFECTIVO ?>">Efectivo</option>
                                        </select>

                                    </div>
                                </div>
                            </div>



                            <div class="col-md-4">
                                <div class="mb-3 row">
                                    <label for="inputPassword" class="col-sm-3 col-form-label">Vendedor</label>
                                    <div class="col-sm-9">
                                        <select name="vendedor" id="vendedor" class="form-control" onchange="saveVendedor()">


                                            <?php
                                            foreach ($usuarios as $usuario) {   ?>
                                                <option value="<?= $usuario->id ?>"><?= $usuario->nombre ?></option>
                                            <?php        }
                                            ?>



                                        </select>

                                    </div>
                                </div>
                            </div>



                        </div>






                    </div>
                </div>
            </div>

        </div>
    </div>



    <div class="row">
        <div class="col-md-12">

            <div class="card mb-4">

                <div class="card-body">
                    <div>

                        <div class="row">

                            <div class="col-md-3">
                                <div class="mb-3 d-flex align-items-center">
                                    <label for="identificacionInput" class=" col-sm-4 form-label me-2">Código</label>
                                    <input type="text" class="form-control" id="codigoProducto">
                                </div>
                            </div>

                            <div class="col-md-4">
                                <div class="mb-3 row">
                                    <label for="inputPassword" class="col-sm-3 col-form-label">Producto</label>
                                    <div class="col-sm-9">
                                        <input type="text" class="form-control" id="nomProducto">
                                    </div>
                                </div>
                            </div>


                            <div class="col-md-2">
                                <div class="mb-3 row">
                                    <label for="inputPassword" class="col-sm-4 col-form-label">PVP.</label>
                                    <div class="col-sm-8">
                                        <input type="text" min=1 class="form-control" id="pvpProducto" disabled>
                                    </div>
                                </div>
                            </div>


                            <div class="col-md-2">
                                <div class="mb-3 row">
                                    <label for="inputPassword" class="col-sm-4 col-form-label">Cant.</label>
                                    <div class="col-sm-8">
                                        <input type="number" min=1 class="form-control" id="cantProducto">
                                    </div>
                                </div>
                            </div>


                            <?php
                            if ($model->fac_estado == Parametros::FACT_IMCOMPLETA) { ?>
                                <div class="col-md-1">
                                    <a class="btn btn-info btn-sm" onclick="agregarItem(event)">Agregar</a>
                                </div>
                            <?php    }
                            ?>


                        </div>


                        <div class="row">
                            <table class="table table-hover">
                                <thead>
                                    <tr>

                                        <th scope="col">Código</th>
                                        <th scope="col">Producto</th>
                                        <th scope="col">Cantidad</th>
                                        <th scope="col">Precio Unitario</th>
                                        <th scope="col">Dscto</th>
                                        <th scope="col">Subtotal</th>
                                        <th scope="col">Acciones</th>
                                    </tr>
                                </thead>
                                <tbody id="tbody">

                                </tbody>
                                <tr>
                                    <td style="background-color: #f1f1f1;" colspan="5"></td>

                                    <td style="background-color: #f1f1f1;">
                                        <h4 id="totalPagar"></h4>
                                    </td>
                                    <td style="background-color: #f1f1f1;" colspan="1">


                                        <?php
                                        if ($model->fac_estado == Parametros::FACT_IMCOMPLETA) { ?>
                                            <button onclick="emitirSeparado('separado')" class="btn btn-success" id="btnEmitirNota">Confirmar Separado</button>
                                        <?php    }
                                        ?>

                                    </td>
                                </tr>
                            </table>
                        </div>



                        <?php

                        if ($model->fac_estado == Parametros::FACT_PROCESO && $model->fac_saldo > 0) { ?>
                            <div class="row">

                                <div class="col-md-2">
                                    <label for="">Monto</label>
                                    <input class="form-control" type="text" id="monto">
                                </div>

                                <div class="col-md-2">

                                    <br>
                                    <a onclick="abonar()" class="btn btn-success">Abonar</a>
                                </div>

                            </div>



                            <div class="col-md-12 pt-4">

                                <table class="table">

                                    <tr>

                                        <th>Fecha</th>
                                        <th>Monto</th>
                                        <th>Saldo</th>
                                    </tr>
                                    <?php
                                    foreach ($detalleSeparados as $detalle) { ?>
                                        <tr>

                                            <td><?= $detalle->fecha ?></td>
                                            <td>$<?= number_format($detalle->monto, 2)  ?></td>
                                            <td>$<?= number_format($detalle->saldo, 2)  ?></td>
                                        </tr>
                                    <?php  }
                                    ?>

                                </table>
                            </div>


                        <?php  }
                        ?>





                    </div>
                </div>
            </div>

        </div>


    </div>








</div>





<script>
    window.onload = function() {
        getDatosCabecera();
        setTimeout(function() {
            getDetalleFactura()
        }, 700);

        $('#codigoProducto').on('keyup', function(event) {
            let inputValue = $(this).val().trim();

            // Si no es la tecla Enter, prevenimos el comportamiento por defecto
            if (event.key !== 'Enter') {
                event.preventDefault(); // Evitar que otras teclas procesen su efecto
            } else if (inputValue !== '') {
                // Solo llamamos a la función si se presiona Enter y el input no está vacío
                consultaProducto();
            }
        });
    };


    function calculaVuelto() {
        let valorPagar = parseFloat($('#valPagar').val());
        let dineroRec = parseFloat($('#dineroRecibido').val());

        // Verificar que los valores sean números válidos
        if (isNaN(valorPagar) || isNaN(dineroRec)) {
            $('#vuelto').val(''); // Limpiar el campo si no son números válidos
            return; // Salir de la función
        }

        let vuelto = 0;

        if (dineroRec >= valorPagar) {
            vuelto = dineroRec - valorPagar;
            // Formatear el vuelto a 2 decimales
            $('#vuelto').val(vuelto.toFixed(2));
        } else {
            $('#vuelto').val(''); // Limpiar el campo si no hay suficiente dinero
        }
    }





    function consultaProducto() {
        let inputValue = $('#codigoProducto').val();

        if (inputValue.trim() !== '') {
            $.get('index.php?r=productos/get-producto&codigo=' + inputValue)
                .done(function(data) {
                    data = JSON.parse(data)
                    if (data.resultado) {
                        $('#nomProducto').val(data.data.pro_nombre);
                        $('#pvpProducto').val(data.data.pro_pvp);

                        $('#cantProducto').val(1);
                        $('#cantProducto').focus();

                    } else {
                        $('#nomProducto').val('');
                        $('#pvpProducto').val('');
                        $('#cantProducto').val();

                        Swal.fire({
                            title: "Oops...",
                            text: data.mensaje ?? 'Producto no encontrado',
                        });
                    }
                })
                .fail(function(xhr, status, error) {
                    console.error('Error en la solicitud:', error);
                });
        }
    }



    function consultaIdentificacion(input) {

        input.value = input.value.replace(/\D/g, '');
        let inputValue = $('#cliIdentificacion').val();
        let factura = '<?= $model->fac_id  ?>'

        if (inputValue.trim() !== '') {

            $.get('index.php?r=clientes/get-cliente&identificacion=' + inputValue + '&factura=' + factura)
                .done(function(data) {
                    data = JSON.parse(data)
                    if (data.resultado) {

                        $('#cliNombre').val(data.data.cli_nombre)
                        $('#cliEmail').val(data.data.cli_correo)
                        $('#cliFono').val(data.data.cli_telefono)
                        $('#cliCelular').val(data.data.cli_celular)
                        $('#cliDireccion').val(data.data.cli_direccion)

                    } else {
                        /*$('#cliNombre').val('')
                        $('#cliEmail').val('')
                        $('#cliFono').val('')
                        $('#cliCelular').val('')
                        $('#cliDireccion').val('')*/
                    }
                })
                .fail(function(xhr, status, error) {
                    // Manejar el error
                    console.error('Error en la solicitud:', error);
                });
        }
    }



    function menos(idDetalle, factura) {
        let metodoPago = $('#metodoPago').val()

        $.get(`index.php?r=productos/restar-detalle&idDetalle=${idDetalle}&factura=${factura}&metodoPago=${metodoPago}`)
            .done(function(data) {
                data = JSON.parse(data)


                console.log(data);

                if (data.transaccion) {
                    getDetalleFactura();
                } else {

                    /*  Swal.fire({
                          title: "Oops...",
                          text: data.error,
                      }); */
                }
            })
            .fail(function(xhr, status, error) {
                // Manejar el error
                console.error('Error en la solicitud:', error);
            });
    }




    function mas(idDetalle, factura) {
        let metodoPago = $('#metodoPago').val()




        $.get(`index.php?r=productos/sumar-detalle&idDetalle=${idDetalle}&factura=${factura}&metodoPago=${metodoPago}`)
            .done(function(data) {
                data = JSON.parse(data)


                console.log(data);

                if (data.transaccion) {
                    getDetalleFactura();
                } else {

                    Swal.fire({
                        title: "Oops...",
                        text: data.error,
                    });
                }
            })
            .fail(function(xhr, status, error) {
                // Manejar el error
                console.error('Error en la solicitud:', error);
            });
    }

    function agregarItem(event) {


        event.preventDefault()

        let codigo = $('#codigoProducto').val()
        let producto = $('#nomProducto').val()
        let pvp = $('#pvpProducto').val()
        let cantidad = $('#cantProducto').val()
        let factura = '<?= $model->fac_id  ?>'
        let metodoPago = $('#metodoPago').val()


        if (codigo.trim() == '' || producto.trim() == '' || pvp.trim() == '' || cantidad.trim() == '') {
            Swal.fire({
                title: "Oops...",
                text: 'Por favor, ingrese todos los campos',
            });
        }


        $.get(`index.php?r=productos/add-producto-factura&codigo=${codigo}&nomProducto=${producto}&cantidad=${cantidad}&factura=${factura}&metodoPago=${metodoPago}`)
            .done(function(data) {
                data = JSON.parse(data)


                if (data.transaccion) {

                    $('#codigoProducto').val('')
                    $('#nomProducto').val('')
                    $('#pvpProducto').val('')
                    $('#cantProducto').val('')

                    getDetalleFactura()

                } else {
                    Swal.fire({
                        title: "Oops...",
                        text: data.error,
                        icon: "error"
                    });
                }
            })
            .fail(function(xhr, status, error) {
                // Manejar el error
                console.error('Error en la solicitud:', error);
            });
    }




    function getDetalleFactura() {
        let factura = '<?= $model->fac_id  ?>'
        let metodoPago = $('#metodoPago').val()

        $.get(`index.php?r=facturas/get-detalle-factura&id=${factura}&metodoPago=${metodoPago}`)
            .done(function(data) {
                data = JSON.parse(data)


                console.log(data);

                if (data.transaccion) {

                    const tbody = document.getElementById('tbody');
                    tbody.innerHTML = '';
                    tbody.innerHTML += data.detalle; // Agregar el string directamente al tbody

                    getValoresFact();

                    ocultaOpciones()

                } else {

                }
            })
            .fail(function(xhr, status, error) {
                // Manejar el error
                console.error('Error en la solicitud:', error);
            });
    }



    function ocultaOpciones() {
        let estado = '<?= $model->fac_estado ?>'
        let incompleta = '<?= Parametros::FACT_IMCOMPLETA ?>'
        if (estado !== incompleta) {
            console.log('elimina')
            $('[name="eliminarReg"]').remove();
            $('[name="modificarReg"]').remove();
        }

    }


    function getDatosCabecera() {
        let factura = '<?= $model->fac_id  ?>'


        $.get(`index.php?r=facturas/get-datos-cabecera&id=${factura}`)
            .done(function(data) {
                data = JSON.parse(data)


                console.log(data);

                if (data.transaccion) {

                    $('#cliIdentificacion').val(data.cliente.cli_identificacion)
                    $('#cliNombre').val(data.cliente.cli_nombre)
                    $('#cliEmail').val(data.cliente.cli_correo)
                    $('#cliFono').val(data.cliente.cli_telefono)
                    $('#cliCelular').val(data.cliente.cli_celular)
                    $('#cliDireccion').val(data.cliente.cli_direccion)


                    $('#metodoPago').val(data.formaPago);
                    $('#vendedor').val(data.usuario);


                } else {

                }
            })
            .fail(function(xhr, status, error) {
                // Manejar el error
                console.error('Error en la solicitud:', error);
            });
    }




    function saveVendedor() {
        let factura = '<?= $model->fac_id  ?>'
        let vendedor = $('#vendedor').val()


        $.get(`index.php?r=facturas/save-vendedor&id=${factura}&idVendedor=${vendedor}`)
            .done(function(data) {
                data = JSON.parse(data)


                console.log(data);

                if (data.transaccion) {

                } else {

                }
            })
            .fail(function(xhr, status, error) {
                // Manejar el error
                console.error('Error en la solicitud:', error);
            });
    }


    function getValoresFact() {

        let factura = '<?= $model->fac_id  ?>'
        let metodoPago = $('#metodoPago').val()
        let pagoTarjeta = '<?= Parametros::TARJETA ?>'


        $.get(`index.php?r=facturas/get-valores-fact&id=${factura}&metodoPago=${metodoPago}`)
            .done(function(data) {
                data = JSON.parse(data)


                if (data.transaccion) {

                    const valPagar = document.getElementById('totalPagar');
                    valPagar.innerHTML = '';
                    valPagar.innerHTML += data.data.fac_total; // Agregar el string directamente al tbody


                    $('#valPagar').val(data.data.fac_total)

                    if (parseFloat(data.data.fac_total) <= 3 && metodoPago !== pagoTarjeta) {
                        $('#btnEmitirPedido').show();
                    } else {
                        $('#btnEmitirPedido').hide();
                    }


                } else {

                }
            })
            .fail(function(xhr, status, error) {
                // Manejar el error
                console.error('Error en la solicitud:', error);
            });

    }


    function eliminarRegistro(idDetalle, factura) {

        $.get(`index.php?r=productos/eliminar-detalle&idDetalle=${idDetalle}&factura=${factura}`)
            .done(function(data) {
                data = JSON.parse(data)


                console.log(data);

                if (data.transaccion) {


                    getDetalleFactura();

                } else {

                }
            })
            .fail(function(xhr, status, error) {
                // Manejar el error
                console.error('Error en la solicitud:', error);
            });
    }


    function actualizaRegistro() {
        alert('elimina')
    }


    function guardaCliente() {

        let identificacion = $('#cliIdentificacion').val().trim()
        let nombre = $('#cliNombre').val().trim()
        let email = $('#cliEmail').val().trim()
        let fono = $('#cliFono').val().trim()
        let celular = $('#cliCelular').val().trim()
        let direccion = $('#cliDireccion').val().trim()
        let factura = '<?= $model->fac_id  ?>'



        if (identificacion.length !== 10 && identificacion.length !== 13) {
            return false;
        }


        if (identificacion.trim() !== '' && nombre.trim() !== '') {
            $.get(`index.php?r=clientes/guarda-cliente&identificacion=${identificacion}&nombre=${nombre}&email=${email}&direccion=${direccion}&fono=${fono}&celular=${celular}&factura=${factura}`)
                .done(function(data) {
                    data = JSON.parse(data)
                    console.log(data);

                    if (data.transaccion) {} else {}
                })
                .fail(function(xhr, status, error) {
                    // Manejar el error
                    console.error('Error en la solicitud:', error);
                });
        }

    }




    function emitirSeparado(tipo) {

        let factura = '<?= $model->fac_id  ?>'
        let identificacion = $('#cliIdentificacion').val().trim()
        let nombre = $('#cliNombre').val()


        if (identificacion.trim() !== '' && nombre != '') {
            $.get(`index.php?r=facturas/emitir-nota&id=${factura}&tipo=${tipo}`)
                .done(function(data) {
                    data = JSON.parse(data)
                    console.log(data);
                    if (data.transaccion) {

                        if (tipo == 'separado') {


                            Swal.fire({
                                text: '¡Separado registrado con éxito! No olvides agregar los abonos y emitir la nota de venta cuando el cliente haya completado el pago.',
                                icon: 'success'
                            }).then((result) => {
                                if (result.isConfirmed || result.isDismissed) {
                                    // Recargar la página
                                    location.reload();
                                }
                            });


                        } else {
                            window.open(`index.php?r=facturas/view&fac_id=${factura}&tipo=${tipo}`, '_blank');
                            window.location.replace('index.php?r=facturas/index');
                        }



                    } else {
                        Swal.fire({
                            title: "Oops...",
                            text: 'Lo sentimos, no pudimos emitir la factura',
                        });
                    }
                })
                .fail(function(xhr, status, error) {
                    // Manejar el error
                    console.error('Error en la solicitud:', error);
                });
        } else {
            Swal.fire({
                title: "Oops...",
                text: 'Por favor, ingrese los datos del cliente',
            });
        }
    }








    function abonar() {

        let factura = '<?= $model->fac_id  ?>'
        let monto = $('#monto').val();

        if (monto.trim() !== '' && parseFloat(monto) > 0) {
            $.get(`index.php?r=detalleseparados/abonar&factura=${factura}&monto=${monto}`)
                .done(function(data) {
                    data = JSON.parse(data)

                    if (data.transaccion) {


                        if (data.facturar) {

                            Swal.fire({
                                text: "Se ha cancelado el saldo pendiente, a continuación, proceda a emitir la factura",
                                icon: "success"
                            }).then((result) => {
                                if (result.isConfirmed || result.isDismissed) {
                                    // Recargar la página

                                    window.location.replace('index.php?r=facturas%2Fupdate&fac_id=' + factura);
                                }
                            });

                        } else {
                            Swal.fire({
                                text: "Se ha registrado el abono de manera correcta",
                                icon: "success"
                            }).then((result) => {
                                if (result.isConfirmed || result.isDismissed) {
                                    // Recargar la página
                                    location.reload();
                                }
                            });
                        }


                    } else {
                        Swal.fire({
                            icon: "error",
                            text: data.error,
                        });
                    }
                })
                .fail(function(xhr, status, error) {
                    console.error('Error en la solicitud:', error);
                });
        }
    }
</script>