<?php

use app\models\Clientes;
use app\models\Facturas;
use app\models\Parametros;
use app\models\User;
use PhpOffice\PhpSpreadsheet\Reader\Xml\Style\NumberFormat;
use yii\helpers\Html;
use yii\helpers\Url;
use yii\grid\ActionColumn;
use yii\grid\GridView;
use yii\helpers\ArrayHelper;
use kartik\daterange\DateRangePicker;

$usuarios = User::find()->all();
$arrayUsuarios = ArrayHelper::map($usuarios, 'id', 'nombre');

/** @var yii\web\View $this */
/** @var app\models\FacturasSearch $searchModel */
/** @var yii\data\ActiveDataProvider $dataProvider */

$this->title = 'Separados';
$this->params['breadcrumbs'][] = $this->title;
?>
<div class="facturas-index">


    <div style="display: flex; justify-content: space-between; margin-bottom: 5px;">
        <h1><?= Html::encode($this->title) ?></h1>
        <div>

            <span style="font-size: 20px; border-right: 2px solid white; color: #515050; display: inline-block; padding-right: 10px; padding-left: 10px; text-align: center;">$<?= number_format($total, 2) ?> <br> <span style="font-size: 14px;">Total ingresos</span> </span>
            <span style="font-size: 20px; border-right: 2px solid white; color: #515050; display: inline-block; padding-right: 10px; padding-left: 10px; text-align: center;">$<?= number_format($totalEfectivo, 2) ?> <br> <span style="font-size: 14px;">Efectivo</span> </span>
            <span style="font-size: 20px; border-right: 2px solid white; color: #515050; display: inline-block; padding-right: 10px; padding-left: 10px; text-align: center;">$<?= number_format($totalTransferencia, 2) ?> <br> <span style="font-size: 14px;">Transferencia</span> </span>
            <span style="font-size: 20px; border-right: 2px solid white; color: #515050; display: inline-block; padding-right: 10px; padding-left: 10px; text-align: center;">$<?= number_format($totalTarjeta, 2) ?> <br> <span style="font-size: 14px;">Tarjeta</span> </span>
        </div>

    </div>


    <p style="text-align: right;">


        <?= Html::a('Agregar separado', ['createseparado'], ['class' => 'btn btn-success', 'target' => '_blank']) ?>

    </p>

    <?php // echo $this->render('_search', ['model' => $searchModel]); 
    ?>




    <div class="row">
        <div class="col-lg-12 mb-4 order-0">
            <div class="card">
                <div class="d-flex align-items-end row">
                    <div class="col-sm-12">
                        <div class="card-body">


                            <?= GridView::widget([
                                'dataProvider' => $dataProvider,
                                'filterModel' => $searchModel,
                                'columns' => [
                                    ['class' => 'yii\grid\SerialColumn'],

                                    //  'fac_id',
                                    //'fac_fecha',

                                    [
                                        'attribute' => 'fac_fecha',
                                        'value' => 'fac_fecha',
                                        'filter' => DateRangePicker::widget([
                                            'model' => $searchModel,
                                            'attribute' => 'fac_fecha',
                                            'convertFormat' => true,
                                            'pluginOptions' => [
                                                'timePicker' => true,
                                                'timePickerIncrement' => 1,
                                                'locale' => [
                                                    'format' => 'Y-m-d H:i:s',  // Formato con fecha y hora
                                                    'separator' => ' a ',        // Separador entre las fechas
                                                ],
                                                // Rango de fecha por defecto: Hoy desde 00:00 hasta 23:59
                                                'startDate' => date('Y-m-d 00:00:00'),
                                                'endDate' => date('Y-m-d 23:59:59'),
                                                'opens' => 'left',
                                            ]
                                        ]),
                                    ],


                                    [

                                        'attribute' => 'fac_tipo',
                                        'format' => 'raw',
                                        'value' => function ($model) {

                                            if ($model->fac_tipo == Parametros::NOTA_VENTA) {
                                                return "<strong style='color:purple; font-size:15px'>{$model->fac_tipo}</strong>";
                                            }

                                            if ($model->fac_tipo == Parametros::NOTA_PEDIDO) {
                                                if ($model->fac_estado !== Parametros::FACT_ANULADA) {
                                                    return "<span style='color:dimgrey; font-size:15px'>{$model->fac_tipo}</span><br><button onClick='emiteNota($model->fac_id)' class='btn btn-success btn-xs '>Emitir nota venta</button>";
                                                } else {
                                                    return "<span style='color:dimgrey; font-size:15px'>{$model->fac_tipo}</span>";
                                                }
                                            }


                                            if ($model->fac_tipo == Parametros::SEPARADO) {

                                                return "<span style='color:dimgrey; font-size:15px'>{$model->fac_tipo}</span>";

                                                if ($model->fac_estado !== Parametros::FACT_ANULADA) {
                                                    return "<span style='color:dimgrey; font-size:15px'>{$model->fac_tipo}</span><br><button onClick='emiteNota($model->fac_id)' class='btn btn-success btn-xs '>Emitir nota venta</button>";
                                                } else {
                                                    return "<span style='color:dimgrey; font-size:15px'>{$model->fac_tipo}</span>";
                                                }
                                            }

                                            return '';
                                        },
                                        'filter' => [Parametros::NOTA_VENTA => 'Nota de Venta', Parametros::NOTA_PEDIDO => 'Nota de Pedido']

                                    ],


                                    [
                                        'attribute' => 'cli_id',
                                        'value' => function ($model) {
                                            $cliente = Clientes::find()->where(['cli_id' => $model->cli_id])->one();
                                            return $cliente->cli_identificacion ?? '';
                                        },


                                    ],


                                    //'fac_subtotal',
                                    //'fac_iva',


                                    [
                                        'attribute' => 'fac_total',
                                        'value' => function ($model) {

                                            return '$' . number_format($model->fac_total, 2);
                                        },


                                    ],


                                    [
                                        'attribute' => 'fac_metodo_pago_id',
                                        'value' => function ($model) {
                                            $metodo = "Efectivo";
                                            if ($model->fac_metodo_pago_id == Parametros::TRANSFERENCIA) {
                                                $metodo = "Transferencia";
                                            } else if ($model->fac_metodo_pago_id == Parametros::TARJETA) {
                                                $metodo = "Tarjeta";
                                            }

                                            return $metodo;
                                        },
                                        'filter' => [Parametros::EFECTIVO => 'Efectivo', Parametros::TRANSFERENCIA => 'Transferencia', Parametros::TARJETA => 'Tarjeta']

                                    ],


                                    [
                                        'attribute' => 'fac_estado',
                                        'format' => 'raw',
                                        'value' => function ($model) {

                                            if ($model->fac_estado == Parametros::FACT_PAGADA) {
                                                return "<span class='badge bg-success '>{$model->fac_estado}</span>";
                                            } else if ($model->fac_estado == Parametros::FACT_ANULADA) {
                                                return "<span class='badge bg-danger '>{$model->fac_estado}</span>";
                                            }

                                            return  "<span class='badge bg-light text-dark '>{$model->fac_estado}</span>";;
                                        },
                                        'filter' => [Parametros::FACT_IMCOMPLETA => 'Incompleta', Parametros::FACT_PAGADA => 'Pagada', Parametros::FACT_ANULADA => 'Anulada']

                                    ],
                                    //'fac_metodo_pago_id',




                                    //'fac_descuento',
                                    //'fact_usuario',
                                    [
                                        'attribute' => 'fac_usuario',
                                        'value' => function ($model) {
                                            $user = User::find()->where(['id' => $model->fac_usuario])->one();
                                            return $user->nombre;
                                        },
                                        'filter' => $arrayUsuarios

                                    ],



                                    [
                                        'class' => ActionColumn::className(),
                                        'urlCreator' => function ($action, Facturas $model, $key, $index, $column) {
                                            return Url::toRoute([$action === 'update' ? 'facturas/updateseparado' : $action, 'fac_id' => $model->fac_id]);
                                        },
                                        'template' => '{update} {delete} ', // Plantilla con {pdf}
                                        'buttons' => [
                                            'update' => function ($url, $model, $key) {
                                                // Verifica si la factura no está pagada para mostrar el botón de edición
                                                if ($model->fac_estado == Parametros::FACT_IMCOMPLETA) {
                                                    return Html::a(
                                                        '<i class="bx bx-edit-alt"></i>',
                                                        $url,
                                                        ['title' => 'Editar Factura']
                                                    );
                                                }

                                                if ($model->fac_estado == Parametros::FACT_PROCESO) {
                                                    return Html::a(
                                                        '<i class="bx bx-money"></i>',
                                                        $url,
                                                        ['title' => 'Abonar']
                                                    );
                                                }

                                                return ''; // Si está pagada, no se muestra el botón de edición
                                            },

                                            'delete' => function ($url, $model, $key) {
                                                // Mensaje de confirmación personalizado

                                                if ($model->fac_estado !== Parametros::FACT_ANULADA) {
                                                    return Html::a(
                                                        '<i class="bx bx-trash"></i>', // Icono de borrar
                                                        $url, // URL de la acción de borrado
                                                        [
                                                            'title' => 'Anular Factura',
                                                            'data-pjax' => '0',
                                                            'data-method' => 'post',
                                                            'onclick' => "
                                                                if (!confirm('¿Estás seguro de que deseas anular esta factura? Esta acción no se puede deshacer.')) {
                                                                    event.preventDefault();
                                                                }
                                                            ",
                                                        ]
                                                    );
                                                }


                                                return '';
                                            },
                                        ],
                                    ],

                                ],
                            ]); ?>

                        </div>
                    </div>

                </div>
            </div>
        </div>
    </div>



</div>



<script>
    function emiteNota(id) {

        let tipo = 'notaventa';

        $.get(`index.php?r=facturas/emitir-nota&id=${id}&tipo=${tipo}`)
            .done(function(data) {
                data = JSON.parse(data)
                if (data.transaccion) {

                    window.open(`index.php?r=facturas/view&fac_id=${id}&tipo=${tipo}`, '_blank');
                    window.location.replace('index.php?r=facturas/index');

                } else {
                    Swal.fire({
                        title: "Oops...",
                        text: 'Lo sentimos, no pudimos emitir la factura',
                    });
                }
            })
            .fail(function(xhr, status, error) {
                // Manejar el error
                console.error('Error en la solicitud:', error);
            });


    }
</script>