<?php

use yii\helpers\Html;
use yii\widgets\DetailView;

/** @var yii\web\View $this */
/** @var app\models\Facturas $model */

$this->title = $model->fac_id;
$this->params['breadcrumbs'][] = ['label' => 'Facturas', 'url' => ['index']];
$this->params['breadcrumbs'][] = $this->title;
\yii\web\YiiAsset::register($this);
?>
<div class="facturas-view">

    <h1><?= Html::encode($this->title) ?></h1>

    <p>
        <?= Html::a('Update', ['update', 'fac_id' => $model->fac_id], ['class' => 'btn btn-primary']) ?>
        <?= Html::a('Delete', ['delete', 'fac_id' => $model->fac_id], [
            'class' => 'btn btn-danger',
            'data' => [
                'confirm' => '¿Estás seguro que deseas eliminar este item?',
                'method' => 'post',
            ],
        ]) ?>
    </p>

    <?= DetailView::widget([
        'model' => $model,
        'attributes' => [
            'fac_id',
            'fac_numero',
            'cli_id',
            'fac_fecha',
            'fac_subtotal',
            'fac_iva',
            'fac_total',
            'fac_estado',
            'fac_metodo_pago_id',
            'fac_descuento',
            'fac_usuario',
            'created_at',
            'updated_at',
            'created_by',
            'updated_by',
        ],
    ]) ?>

</div>