<?php

use app\models\Parametros;
use app\models\Tipogastos;
use yii\helpers\Html;
use yii\widgets\ActiveForm;
use yii\helpers\ArrayHelper;


$catalogo = Tipogastos::find()->where(['tip_estado' => Parametros::ACTIVO])->all();
$arrayCatalogo = ArrayHelper::map($catalogo, 'tip_gasto_id', 'tip_gasto_nombre');

/** @var yii\web\View $this */
/** @var app\models\Gastos $model */
/** @var yii\widgets\ActiveForm $form */
?>

<div class="gastos-form">

    <?php $form = ActiveForm::begin(); ?>

    <div class="row">
        <div class="col-md-6">

            <div class="card mb-4">
                <h5 class="card-header">Campos generales</h5>
                <div class="card-body">
                    <div>



                        <label for="">
                            Fecha
                        </label>
                        <?= \yii\helpers\Html::input('date', 'gas_fecha', date('Y-m-d'), [
                            'class' => 'form-control',
                            'max' => date('Y-m-d'),
                        ]) ?>

                        <br>


                        <?= $form->field($model, 'gas_descripcion')->textInput() ?>


                        <?= $form->field($model, 'gas_tipo')->dropDownList($arrayCatalogo, ['prompt' => 'Seleccione una opción']) ?>

                        <?= $form->field($model, 'gas_valor') ?>

                        <?= $form->field($model, 'gas_estado')->dropDownList([Parametros::ACTIVO => 'Activo', Parametros::INACTIVO => 'Inactivo']) ?>


                    </div>
                </div>
            </div>

        </div>
    </div>




    <div class="form-group">
        <?= Html::submitButton('Guardar', ['class' => 'btn btn-success']) ?>
    </div>

    <?php ActiveForm::end(); ?>

</div>