<?php

use app\models\Tipogastos;
use app\models\User;
use yii\helpers\Html;
use yii\widgets\DetailView;

/** @var yii\web\View $this */
/** @var app\models\Gastos $model */

$this->title = $model->gas_id;
$this->params['breadcrumbs'][] = ['label' => 'Gastos', 'url' => ['index']];
$this->params['breadcrumbs'][] = $this->title;
\yii\web\YiiAsset::register($this);
?>
<div class="gastos-view">





    <div class="row">
        <div class="col-lg-12 mb-4 order-0">
            <div class="card">
                <div class="d-flex align-items-end row">
                    <div class="col-sm-12">
                        <div class="card-body">

                            <?= DetailView::widget([
                                'model' => $model,
                                'attributes' => [
                                    //         'gas_id',
                                    'gas_fecha',
                                    'gas_descripcion',

                                    [
                                        'attribute' => 'gas_tipo',
                                        'value' => function ($model) {
                                            $tipo = Tipogastos::find()->where(['tip_gasto_id' => $model->gas_tipo])->one();
                                            return $tipo->tip_gasto_nombre;
                                        },

                                    ],


                                    //'gas_valor',

                                    [
                                        'attribute' => 'gas_valor',
                                        'value' => function ($model) {
                                            $valor = number_format($model->gas_valor, 2);
                                            return "$$valor";
                                        },

                                    ],


                                    'created_at',
                                    'updated_at',
                                    [
                                        'attribute' => 'created_by',
                                        'value' => function ($model) {
                                            $user = User::find()->where(['id' => $model->created_by])->one();
                                            return $user->nombre;
                                        },

                                    ],
                                    [
                                        'attribute' => 'updated_by',
                                        'value' => function ($model) {
                                            $user = User::find()->where(['id' => $model->updated_by])->one();
                                            return $user->nombre;
                                        },

                                    ]

                                ],
                            ]) ?>

                        </div>
                    </div>

                </div>
            </div>
        </div>
    </div>




</div>