<?php

/** @var yii\web\View $this */
/** @var string $content */

use app\assets\AppAsset;
use app\widgets\Alert;
use yii\bootstrap5\Breadcrumbs;
use yii\bootstrap5\Html;
use yii\bootstrap5\Nav;
use yii\bootstrap5\NavBar;

use app\models\Instituto;



AppAsset::register($this);

$this->registerCsrfMetaTags();
$this->registerMetaTag(['charset' => Yii::$app->charset], 'charset');
$this->registerMetaTag(['name' => 'viewport', 'content' => 'width=device-width, initial-scale=1, shrink-to-fit=no']);
$this->registerMetaTag(['name' => 'description', 'content' => $this->params['meta_description'] ?? '']);
$this->registerMetaTag(['name' => 'keywords', 'content' => $this->params['meta_keywords'] ?? '']);
$this->registerLinkTag(['rel' => 'icon', 'type' => 'image/x-icon', 'href' => Yii::getAlias('@web/favicon.ico')]);
?>
<?php $this->beginPage() ?>
<!DOCTYPE html>
<html lang="<?= Yii::$app->language ?>" class="h-100">

<head>
    <title><?= Html::encode($this->title) ?></title>
    <?php $this->head() ?>
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Dancing+Script&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/animate.css/4.1.1/animate.min.css" />

    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Montserrat:wght@400&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css" integrity="sha512-DTOQO9RWCH3ppGqcWaEA1BIZOC6xxalwEsw9c2QQeAIftl+Vegovlnee1c9QX4TctnWMn13TZye+giMm8e2LwA==" crossorigin="anonymous" referrerpolicy="no-referrer" />

    <!--script src="//code.jivosite.com/widget/18yHaLXE5j" async></!--script-->



    <style>
        p {
            font-family: 'Montserrat', sans-serif;
            font-weight: 400;
        }

        .btn-primary {
            background-color: #1458A4;
        }

        .carrera-img:hover {
            filter: opacity(.6);
        }

        .heartbeat-button {
            font-size: 18px;
            padding: 10px 20px;
            border: none;
            background-color: #007bff;
            color: #fff;
            border-radius: 5px;
            cursor: pointer;
            animation: heartbeat 2s infinite ease-in-out;
            background-color: #1458A4;
        }

        .nav-link {
            color: white;
        }

        .nav-link:hover {
            font-weight: 500;
            color: white;
        }

        .nav-link2 {
            color: grey;
            text-decoration: none;
            font-size: 13px;
        }

        .logos img {
            width: 85%;
            display: block;
            margin: auto;
        }

        .accordion-button:not(.collapsed) {
            color: white;
            background-color: #1458A4;
        }

        @keyframes heartbeat {

            0%,
            100% {
                transform: scale(1);
            }

            50% {
                transform: scale(1.1);
            }
        }

        .carouselExampleControls {
            padding: 5%;
        }

        .card {
            border: none;
        }

        .btn-primary {}

        .floating-button {
            position: fixed;
            /* Posicionamiento fijo en la pantalla */
            bottom: 50px;
            /* 10px desde la parte inferior de la pantalla */
            right: 10px;
            /* 10px desde la parte derecha de la pantalla */
            z-index: 999;
            /* Asegura que el botón esté por encima de otros elementos */
        }


        .floating-button2 {
            position: fixed;
            /* Posicionamiento fijo en la pantalla */
            bottom: 100px;
            /* 10px desde la parte inferior de la pantalla */
            right: 10px;
            /* 10px desde la parte derecha de la pantalla */
            z-index: 999;
            /* Asegura que el botón esté por encima de otros elementos */
        }



        .floating-button button:hover {
            background-color: #166da7;
            opacity: 1;
        }
    </style>
</head>

<body class="d-flex flex-column h-100">




    <?php $this->beginBody() ?>




    <main id="main" class="flex-shrink-0" role="main">
        <div class="" style="padding-top: 0px; margin: 0px;">
            <?php if (!empty($this->params['breadcrumbs'])): ?>
                <?= Breadcrumbs::widget(['links' => $this->params['breadcrumbs']]) ?>
            <?php endif ?>
            <?= Alert::widget() ?>
            <?= $content ?>
        </div>
    </main>






    <div style="background-color: #193C78;">
        <div class="container">


            <section>




            </section>
        </div>
    </div>


    <footer id="footer" class="mt-auto bg-light">
        <div class="container">
            <div class="row text-muted">
                <div class="col-md-6 text-center text-md-start">&copy;Derechos reservados Tecnicentro del calefón<?= date('Y') ?></div>
            </div>
        </div>
    </footer>

    <script>
        var tooltipTriggerList = [].slice.call(document.querySelectorAll('[data-bs-toggle="tooltip"]'))
        var tooltipList = tooltipTriggerList.map(function(tooltipTriggerEl) {
            return new bootstrap.Tooltip(tooltipTriggerEl)
        })
    </script>

    <?php $this->endBody() ?>
</body>

</html>
<?php $this->endPage() ?>