<?php

use yii\helpers\Html;
use yii\widgets\DetailView;

/** @var yii\web\View $this */
/** @var app\models\Metodospago $model */

$this->title = $model->met_pago_id;
$this->params['breadcrumbs'][] = ['label' => 'Metodospagos', 'url' => ['index']];
$this->params['breadcrumbs'][] = $this->title;
\yii\web\YiiAsset::register($this);
?>
<div class="metodospago-view">

    <h1><?= Html::encode($this->title) ?></h1>

    <p>
        <?= Html::a('Update', ['update', 'met_pago_id' => $model->met_pago_id], ['class' => 'btn btn-primary']) ?>
        <?= Html::a('Delete', ['delete', 'met_pago_id' => $model->met_pago_id], [
            'class' => 'btn btn-danger',
            'data' => [
                'confirm' => '¿Estás seguro que deseas eliminar este item?',
                'method' => 'post',
            ],
        ]) ?>
    </p>

    <?= DetailView::widget([
        'model' => $model,
        'attributes' => [
            'met_pago_id',
            'met_pago_nombre',
            'met_pago_estado',
            'created_at',
            'updated_at',
            'created_by',
            'updated_by',
        ],
    ]) ?>

</div>