<?php

use app\models\Profesores;
use yii\helpers\Html;
use yii\widgets\ActiveForm;
use yii\helpers\ArrayHelper;


$profesores = Profesores::find()->where(['estado' => 'A'])->all();
$arrayProfesores = ArrayHelper::map($profesores, 'id', 'nickName');

/** @var yii\web\View $this */
/** @var app\models\Niveles $model */
/** @var yii\widgets\ActiveForm $form */
?>

<div class="niveles-form">

  <?php $form = ActiveForm::begin(); ?>

  <div class="col-md-6">

    <div class="card mb-4">
      <h5 class="card-header">Datos generales</h5>
      <div class="card-body">
        <div>

          <!-- input -->

          <?= $form->field($model, 'codigo')->textInput(['maxlength' => true]) ?>

          <?= $form->field($model, 'nivel')->textInput(['maxlength' => true]) ?>

          <?= $form->field($model, 'estado')->dropDownList(['A' => 'Activo', 'I' => 'Inactivo']) ?>

          <?= $form->field($model, 'tutor')->dropDownList($arrayProfesores, ['prompt' => 'Selecciona una opción']) ?>

          <?= $form->field($model, 'instituto')->textInput(['maxlength' => true]) ?>




        </div>
      </div>
    </div>

  </div>



  <div class="form-group">
    <?= Html::submitButton('Guardar', ['class' => 'btn btn-success']) ?>
  </div>

  <?php ActiveForm::end(); ?>

</div>