<?php

use app\models\Empresa;
use app\models\Marcas;
use app\models\Productos;
use yii\helpers\Html;


$empresa = Empresa::find()->where(['codigo' => 'miller'])->one();
$productos = Productos::find()->all();

?>


<style>
    .etiqueta {
        font-weight: 120;
        font-size: 30px;
        background-color: #f1f1f1;
        padding: 10px 35px;
        border-radius: 55px;
        color: grey
    }


    .card_servicio {
        border: 1px solid white;
        border-radius: 25px;
        padding: 25px 25px 8px 25px;
        width: 22%;
        background-color: #ffffffd9;
    }



    @media (max-width: 767px) {
        .card_servicio {
            width: 80%;
            margin: auto;
            margin-bottom: 20px;
        }
    }

    .card_contacto {
        border: none;
        border-radius: 25px;
        padding: 25px;
        background-color: #ffffff;
        margin: 15px;
        width: 75%;
        margin: auto;
    }


    .btn-card {
        padding: 6px;
        border: none;
        border-radius: 15px;
        color: white;
        background-color: #ef7993;
        opacity: 80%;

    }


    .btn-card:hover {
        padding: 6px;
        border: none;
        border-radius: 15px;
        color: white;
        background-color: #ef7993;
        opacity: 100%;

    }


    @media (max-width: 767px) {
        .display-2 {
            text-align: center;
        }

        .display-3 {
            text-align: center;
        }
    }
</style>


<!-- Bootstrap JS -->
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>

<div class="pt-5 pb-5" style="background-image: url('<?= Yii::$app->urlManager->baseUrl . '/uploads/images/' . $empresa->imagen_banner; ?>'); background-repeat: no-repeat; background-position: center; background-size: cover;">



    <div class="container" id="inicio">
        <div class="row">
            <div class="col-md-4" style="display: flex; flex-direction: column;justify-content: center;">
               
            <br>
            <img style=" display: block; width: 30%; " class="img-fluid" src="<?= Yii::$app->urlManager->baseUrl . '/uploads/images/' . $empresa->logotipo ?>" alt="">

                <p style=" font-weight: 100; text-align: justify; font-weight: 500; margin-top: 40px;"><?= $empresa->descripcion_banner ?></p>

                <br><br>



            </div>


        </div>
    </div>
</div>










<section id="productoActual" class="" style="background-color: #fff;">
    <div class="container">
        <div class="row" style="padding-top: 60px; padding-bottom: 20px;">

            <div class="row">
                <!--Carreras-->
                <div class="col-md-12">
                    <div class="row py-4">

                        <div class="col-md-4">
                            <img
                                style="border-radius: 10px; max-height: 500px; width: auto"
                                class="card-img-top img-fluid carrera-img"
                                src="<?= Yii::$app->urlManager->baseUrl . '/uploads/images/' . $model->pro_foto ?> "
                                alt="">
                        </div>

                        <div class="col-md-8">

                            <h1 class="display-2"><?= $model->pro_nombre ?></h1>
                            <p><?= $model->pro_descripcion ?></p>

                            
                            <p><strong>Stock:</strong> <?= $model->pro_stock ?> und. </p>

                        </div>





                    </div>
                </div>

            </div>

        </div>
    </div>
</section>



<section id="catalogo" class="d-none d-md-block" style="background-color: #fff;">
    <div class="container">
        <div class="row" style="padding-top: 0px; padding-bottom: 20px;">

            <div class="row">
                <!--Carreras-->
                <div class="col-md-12">
                    <div class="row py-4">




                        <div class="row">
                            <div id="carouselExampleControls" class="carousel carousel-dark slide" data-bs-ride="carousel">

                                <div class="carousel-inner" style="padding-left: 15px; padding-right: 15px;">
                                    <?php
                                    $chunks = array_chunk($productos, 6);
                                    foreach ($chunks as $key => $chunk) {
                                        $activeClass = $key === 0 ? 'active' : ''; // Establecer la primera fila como activa

                                        // Generar una nueva carousel-item para cada trozo de 3 elementos
                                        echo '<div class="carousel-item ' . $activeClass . '">
                                            <div class="row">';

                                        foreach ($chunk as $producto) {
                                            // Generar cada elemento de la fila
                                            $precioNeto = $producto['pro_pvp'];
                                            $precioFinal = $producto['pro_pvp'];
                                            $marcaProd = '';

                                            if (!empty($producto['pro_marca'])) {
                                                $marca = Marcas::find()->where(['mar_id' => $producto['pro_marca']])->one();
                                                $marcaProd =  $marca['mar_nombre'];
                                            }


                                            if (isset($producto['aplicaDescuento']) && $producto['aplicaDescuento'] && !empty($producto['porcDescuento'])) {
                                                $precioFinal = $precioNeto - ($precioNeto / 100 * floatval($producto['porcDescuento']));
                                            }


                                            if (isset($producto['aplicaDescuento']) && $producto['aplicaDescuento']) {
                                                echo '<div class="col-md-3" style="padding: 15px;">
                                                
                                            <div class="card h-100">
                                            <div class="card-body d-grid">
                                            <div style="position: absolute; right: 0px; top: 0px; background-color: #1770ac; color: white; border-radius: 50%; padding: 10px; display: flex; align-items: center; justify-content: center;">
                                                <h5>' . $producto['porcDescuento'] . '%</h5>
                                                <span style="font-size: 13px">Dscto</span>
                                            </div>
                                            <img style="border-radius: 10px; width: 100%" class="card-img-top img-fluid carrera-img" src="' . Yii::$app->urlManager->baseUrl . '/uploads/images/' . $producto['pro_foto'] . '" alt="">
                                            
        
                                                <span style="text-align:center; font-size:16px;margin-bottom:8px; font-weight:500; color:gray">' . $producto['producto'] . '</span>
                                                <span style="text-align:center; font-size:13px;margin-bottom:8px; font-weight:500; background-color: #f1f1f1; border-radius:20px; color:gray; display: inline-block">' . $producto['marca'] . '</span>
                                                
                                                    ' . Html::a(
                                                    'Ver detalle',
                                                    ['productos/ver-producto', 'id' => $producto['id']],
                                                    ['class' => ' btn-card btn-sm btn-block']
                                                ) . '
                                                </div>
                                            </div>
                                        </div>';
                                            } else {
                                                echo '<div class="col-md-2" style="padding: 15px;">
                                                
                                            <div class="card h-100">
                                            <div class="card-body d-grid">
                                         
                                            <img style="border-radius: 10px; width: 100%" class="card-img-top img-fluid carrera-img" src="' . Yii::$app->urlManager->baseUrl . '/uploads/images/' . $producto['pro_foto'] . '" alt="">
                                            
        
                                                <span style="text-align:center; font-size:16px;margin-bottom:8px; font-weight:500; color:gray">' . $producto['pro_nombre'] . '</span>
                                                <span style="text-align:center; font-size:13px;margin-bottom:8px; font-weight:500; display: inline-block">' . $marcaProd . '</span>
                                                
                                                    ' . Html::a(
                                                    'Ver detalle',
                                                    ['productos/ver-producto', 'id' => $producto['pro_id']],
                                                    ['class' => 'btn btn-card btn-sm btn-block']
                                                ) . '
                                                </div>
                                            </div>
                                        </div>';
                                            }
                                        }

                                        // Calcular el número de tarjetas adicionales necesarias para completar la fila
                                        $remainingCards = count($chunk);
                                        $remainingCols = 6 - $remainingCards;

                                        // Mostrar columnas vacías si es necesario
                                        if ($remainingCols > 0) {
                                            for ($i = 0; $i < $remainingCols; $i++) {
                                                echo '<div class="col-md-3"></div>';
                                            }
                                        }

                                        echo '</div></div>';
                                    }
                                    ?>

                                </div>


                                <button class="carousel-control-prev" type="button" data-bs-target="#carouselExampleControls" data-bs-slide="prev" style="width: auto;">
                                    <span class="carousel-control-prev-icon" aria-hidden="true"></span>
                                    <span class="visually-hidden">Previous</span>
                                </button>
                                <button class="carousel-control-next" type="button" data-bs-target="#carouselExampleControls" data-bs-slide="next" style="width: auto">
                                    <span class="carousel-control-next-icon" aria-hidden="true"></span>
                                    <span class="visually-hidden">Next</span>
                                </button>
                            </div>
                        </div>

                    </div>
                </div>




            </div>

        </div>



    </div>
</section>





<section id="catalogo" class="d-block d-md-none" style="background-color: #fff;">
    <div class="container">

        <div class="row" style=" padding-bottom: 20px;">



            <!--Carreras-->
            <div class="col-md-12">


                <div class="row">
                    <div id="carouselExampleControls2" class="carousel carousel-dark slide" data-bs-ride="carousel">

                        <div class="carousel-inner" style="padding-left: 15px; padding-right: 15px;">
                            <?php
                            $chunks = array_chunk($productos, 2);
                            foreach ($chunks as $key => $chunk) {
                                $activeClass = $key === 0 ? 'active' : ''; // Establecer la primera fila como activa

                                // Generar una nueva carousel-item para cada trozo de 3 elementos
                                echo '<div class="carousel-item ' . $activeClass . '">
                                            <div class="row">';

                                foreach ($chunk as $producto) {
                                    // Generar cada elemento de la fila
                                    $precioNeto = $producto['pro_pvp'];
                                    $precioFinal = $producto['pro_pvp'];
                                    $marcaProd = '';

                                    if (!empty($producto['pro_marca'])) {
                                        $marca = Marcas::find()->where(['mar_id' => $producto['pro_marca']])->one();
                                        $marcaProd =  $marca['mar_nombre'];
                                    }


                                    if (isset($producto['aplicaDescuento']) && $producto['aplicaDescuento'] && !empty($producto['porcDescuento'])) {
                                        $precioFinal = $precioNeto - ($precioNeto / 100 * floatval($producto['porcDescuento']));
                                    }


                                    if (isset($producto['aplicaDescuento']) && $producto['aplicaDescuento']) {
                                        echo '<div class="col-6" style="padding: 15px;">
                                                
                                            <div class="card h-100">
                                            <div class="card-body d-grid">
                                            <div style="position: absolute; right: 0px; top: 0px; background-color: #1770ac; color: white; border-radius: 50%; padding: 10px; display: flex; align-items: center; justify-content: center;">
                                                <h5>' . $producto['porcDescuento'] . '%</h5>
                                                <span style="font-size: 13px">Dscto</span>
                                            </div>
                                            <img style="border-radius: 10px; width: 100%" class="card-img-top img-fluid carrera-img" src="' . Yii::$app->urlManager->baseUrl . '/uploads/images/' . $producto['pro_foto'] . '" alt="">
                                            
        
                                                <span style="text-align:center; font-size:16px;margin-bottom:8px; font-weight:500; color:gray">' . $producto['producto'] . '</span>
                                                <span style="text-align:center; font-size:13px;margin-bottom:8px; font-weight:500; background-color: #f1f1f1; border-radius:20px; color:gray; display: inline-block">' . $producto['marca'] . '</span>
                                                
                                                    ' . Html::a(
                                            'Ver detalle',
                                            ['productos/ver-producto', 'id' => $producto['id']],
                                            ['class' => ' btn-card btn-sm btn-block']
                                        ) . '
                                                </div>
                                            </div>
                                        </div>';
                                    } else {
                                        echo '<div class="col-6" >
                                                
                                            <div class="card h-100">
                                            <div class="card-body d-grid">
                                         
                                            <img style="border-radius: 10px; width: 100%" class="card-img-top img-fluid carrera-img" src="' . Yii::$app->urlManager->baseUrl . '/uploads/images/' . $producto['pro_foto'] . '" alt="">
                                            <span style="text-align:center; font-size:20px;margin-bottom:8px; font-weight:500; color:#1770ac">Precio: $' . number_format($precioFinal, 2) . '</span>
        
                                                <span style="text-align:center; font-size:16px;margin-bottom:8px; font-weight:500; color:gray">' . $producto['pro_nombre'] . '</span>
                                                <span style="text-align:center; font-size:13px;margin-bottom:8px; font-weight:500; display: inline-block">' . $marcaProd . '</span>
                                                
                                                    ' . Html::a(
                                            'Ver detalle',
                                            ['productos/ver-producto', 'id' => $producto['pro_id']],
                                            ['class' => 'btn btn-card btn-sm btn-block']
                                        ) . '
                                                </div>
                                            </div>
                                        </div>';
                                    }
                                }

                                // Calcular el número de tarjetas adicionales necesarias para completar la fila
                                $remainingCards = count($chunk);
                                $remainingCols = 2 - $remainingCards;

                                // Mostrar columnas vacías si es necesario
                                if ($remainingCols > 0) {
                                    for ($i = 0; $i < $remainingCols; $i++) {
                                        echo '<div class="col-md-3"></div>';
                                    }
                                }

                                echo '</div></div>';
                            }
                            ?>

                        </div>


                        <button class="carousel-control-prev" type="button" data-bs-target="#carouselExampleControls2" data-bs-slide="prev" style="width: auto;">
                            <span class="carousel-control-prev-icon" aria-hidden="true"></span>
                            <span class="visually-hidden">Previous</span>
                        </button>
                        <button class="carousel-control-next" type="button" data-bs-target="#carouselExampleControls2" data-bs-slide="next" style="width: auto">
                            <span class="carousel-control-next-icon" aria-hidden="true"></span>
                            <span class="visually-hidden">Next</span>
                        </button>
                    </div>
                </div>



            </div>





        </div>

        <div class=" text-center">
            <a href="index.php?r=productos/ver-catalogo" class="btn btn-primary btn-lg heartbeat-button" style="border-radius: 25px; z-index: 20;background-color: #05acac;">Explora nuestro catálogo</a>
        </div>

    </div>
</section>



<!-- INSTITUTO -->
<section class=" pb-5 pt-5 " id="contactanos" style="margin-top:75px; background-color: #efefef;">

    <div class="container">
        <div class="row" style="display: flex; align-items: center; padding-top: 30px; padding-bottom: 30px;  color:grey">

            <div class="col-md-4">

                <a target="_blank" href="<?= $empresa->googlemaps ?>">
                    <img style="display: block; margin: auto; width:90%" class="img-fluid" src="<?= Yii::$app->urlManager->baseUrl . '/uploads/images/' . $empresa->mapa ?>" alt="">
                </a>
                <br>
                <p class="text-center" style="font-size: 13px;">Presiona sobre el mapa para ver la ubicación</p>


            </div>

            <div class="col-md-8">
                <h2 class="display-3" style="color: #37517e;">Contáctanos</h2>
                <p>
                    ¿Tienes alguna inquietud? No dudes en contactarnos, estamos listos para atenderte.
                </p>
                <br>

                <div class="card_contacto">

                    <div class="row">
                        <div class="col-md-4">
                            <img style="display: block; margin: auto; " class="img-fluid" src="<?= Yii::$app->urlManager->baseUrl . '/uploads/images/contactanos.png' ?>" alt="">
                        </div>
                        <div class="col-md-8">
                            <h3 style="color:#08326f"> Horario de atención:</h3>


                            <?php
                            $horarios = explode(',', $empresa->horario_atencion);

                            foreach ($horarios as $horario) { ?>
                                <p><?= $horario ?></p>
                            <?php }
                            ?>


                            <hr>

                            <p>Llámanos al: <?= $empresa->telefonos ?></p>

                            <hr>

                            <p>Ubícanos en: <?= $empresa->direccion ?></p>
                        </div>
                    </div>



                </div>


            </div>



        </div>
    </div>
    </div>

</section>



<script>
    function enviarWhatsApp(tipo) {
        let mensaje = 'Hola deseo más información por favor';


        var url = "https://api.whatsapp.com/send?phone=593" + <?= $empresa->whatsapp ?> + "&text=" + encodeURIComponent(mensaje);
        window.open(url, '_blank');
    }
</script>