<?php

use app\models\Categorias;
use app\models\Colores;
use app\models\Marcas;
use app\models\Proveedores;
use app\models\User;
use yii\helpers\Html;
use yii\widgets\DetailView;
use Yii;


$userModel = Yii::$app->user->identity;
$esAdmin = false;
if (!empty($userModel->rol) && $userModel->rol === 'superAdmin') {
    $esAdmin = true;
}

/** @var yii\web\View $this */
/** @var app\models\Productos $model */

$this->title = $model->pro_id;
$this->params['breadcrumbs'][] = ['label' => 'Productos', 'url' => ['index']];
$this->params['breadcrumbs'][] = $this->title;
\yii\web\YiiAsset::register($this);
?>
<div class="productos-view">


    <p>
        <?php
        if ($esAdmin) {
            Html::a('Actualizar', ['update', 'pro_id' => $model->pro_id], ['class' => 'btn btn-success btn-sm']);
        }
        ?>

    </p>



    <div class="row">
        <div class="col-lg-12 mb-4 order-0">
            <div class="card">
                <div class="d-flex align-items-end row">
                    <div class="col-sm-12">
                        <div class="card-body">

                            <?= DetailView::widget([
                                'model' => $model,

                                'attributes' => [
                                    //    'pro_id',
                                    'pro_nombre',
                                    'pro_codigo',
                                    //'prov_id',

                                    [
                                        'attribute' => 'prov_id',
                                        'value' => function ($model) {
                                            $proveedor = Proveedores::find()->where(['prov_id' => $model->prov_id])->one();
                                            return $proveedor->prov_nombre ?? '';
                                        },

                                    ],







                                    [
                                        'attribute' => 'pro_foto',
                                        'format' => 'raw',
                                        'value' => function ($model) {
                                            return '<img 
                                                style="border-radius: 10px; max-height: 200px; width: auto" 
                                                class="card-img-top img-fluid carrera-img" 
                                                src="' . Yii::$app->urlManager->baseUrl . '/uploads/images/' . $model->pro_foto . '" 
                                                alt="">';
                                        },

                                    ],

                                    [
                                        'attribute' => 'pro_talla',
                                        'value' => $model->pro_talla !== null ? $model->pro_talla : '',
                                    ],
                                    //'cat_id',

                                    [
                                        'attribute' => 'cat_id',
                                        'value' => function ($model) {
                                            $categorias = Categorias::find()->where(['cat_id' => $model->cat_id])->one();
                                            return $categorias->cat_nombre ?? '';
                                        },

                                    ],


                                    'pro_modelo',
                                    //  'pro_color',

                                    [
                                        'attribute' => 'pro_color',
                                        'value' => function ($model) {
                                            $colores = Colores::find()->where(['col_id' => $model->pro_color])->one();
                                            return $colores->col_nombre ?? '';
                                        },

                                    ],

                                    // 'pro_costo',
                                    // 'pro_pvp',


                                    [
                                        'attribute' => 'pro_costo',
                                        'value' => function ($model) {
                                            $valor = number_format($model->pro_costo, 2);
                                            return "$$valor";
                                        },

                                    ],


                                    [
                                        'attribute' => 'pro_pvp',
                                        'value' => function ($model) {
                                            $valor = number_format($model->pro_pvp, 2);
                                            return "$$valor";
                                        },

                                    ],




                                    [
                                        'attribute' => 'pro_pvp_tarjeta',
                                        'value' => function ($model) {
                                            $valor = number_format($model->pro_pvp_tarjeta, 2);
                                            return "$$valor";
                                        },

                                    ],


                                    // 'pro_dscto',




                                    [
                                        'attribute' => 'pro_descripcion',
                                        'format' => 'raw',
                                        'value' => function ($model) {
                                            return  $model->pro_descripcion;
                                        },

                                    ],



                                    [
                                        'attribute' => 'pro_marca',
                                        'value' => function ($model) {
                                            $marcas = Marcas::find()->where(['mar_id' => $model->pro_marca])->one();
                                            return $marcas->mar_nombre ?? '';
                                        },

                                    ],


                                    'pro_stock',

                                    'created_at',
                                    'updated_at',



                                    [
                                        'attribute' => 'created_by',
                                        'value' => function ($model) {
                                            $user = User::find()->where(['id' => $model->created_by])->one();
                                            return $user->nombre;
                                        },

                                    ],
                                    [
                                        'attribute' => 'updated_by',
                                        'value' => function ($model) {
                                            $user = User::find()->where(['id' => $model->updated_by])->one();
                                            return $user->nombre;
                                        },

                                    ]

                                ],
                            ]) ?>


                        </div>
                    </div>

                </div>
            </div>
        </div>
    </div>





</div>