<?php

use app\models\Detalleseparados;
use app\models\Metodospago;
use app\models\Parametros;
use app\models\User;
use yii\helpers\Html;
use yii\widgets\ActiveForm;
use yii\helpers\ArrayHelper;



$detSeparados = Detalleseparados::find()->where(['separado_id' => $model->id])->all();


/** @var yii\web\View $this */
/** @var app\models\Facturas $model */
/** @var yii\widgets\ActiveForm $form */
?>


<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>




<div class="facturas-form">





    <div class="row">
        <div class="col-md-12">

            <div class="card mb-4">

                <div class="card-body">
                    <div>

                        <div class="row">

                            <div class="col-md-4">
                                <div class="mb-3 row">
                                    <label for="inputPassword" class="col-sm-4 col-form-label">Identificación</label>
                                    <div class="col-sm-8">
                                        <input type="text" class="form-control" id="cliIdentificacion" value="<?= $cliente->cli_identificacion ?>">
                                    </div>
                                </div>
                            </div>

                            <div class="col-md-5">
                                <div class="mb-3 row">
                                    <label for="inputPassword" class="col-sm-3 col-form-label">Nombre</label>
                                    <div class="col-sm-9">
                                        <input type="text" class="form-control" id="cliNombre" value="<?= $cliente->cli_identificacion ?>">
                                    </div>
                                </div>
                            </div>


                            <div class="col-md-3">
                                <div class="mb-3 row">
                                    <label for="inputPassword" class="col-sm-3 col-form-label">Email</label>
                                    <div class="col-sm-9">
                                        <input type="text" class="form-control" id="cliEmail" value="<?= $cliente->cli_identificacion ?>">
                                    </div>
                                </div>
                            </div>

                        </div>

                        <div class="row">

                            <div class="col-md-6">
                                <div class="mb-3 row">
                                    <label for="inputPassword" class="col-sm-2 col-form-label">Dirección</label>
                                    <div class="col-sm-10">
                                        <input type="text" class="form-control" id="cliDireccion" value="<?= $cliente->cli_direccion ?>">
                                    </div>
                                </div>
                            </div>

                            <div class="col-md-3">
                                <div class="mb-3 row">
                                    <label for="inputPassword" class="col-sm-4 col-form-label">Teléfono</label>
                                    <div class="col-sm-8">
                                        <input type="text" class="form-control" id="cliFono" value="<?= $cliente->cli_telefono ?>">
                                    </div>
                                </div>
                            </div>


                            <div class="col-md-3">
                                <div class="mb-3 row">
                                    <label for="inputPassword" class="col-sm-3 col-form-label">Celular</label>
                                    <div class="col-sm-9">
                                        <input type="text" class="form-control" id="cliCelular" value="<?= $cliente->cli_celular ?>">
                                    </div>
                                </div>
                            </div>

                        </div>

                        <hr>

                    </div>
                </div>
            </div>

        </div>
    </div>



    <div class="row">
        <div class="col-md-12">

            <div class="card mb-4">

                <div class="card-body">
                    <div>

                        <div class="row">

                            <div class="col-md-3">
                                <div class="mb-3 d-flex align-items-center">
                                    <label for="identificacionInput" class=" col-sm-4 form-label me-2">Código</label>
                                    <input type="text" class="form-control" id="codigoProducto" value="<?= $producto->pro_codigo ?>">
                                </div>
                            </div>

                            <div class="col-md-4">
                                <div class="mb-3 row">
                                    <label for="inputPassword" class="col-sm-3 col-form-label">Producto</label>
                                    <div class="col-sm-9">
                                        <input type="text" class="form-control" id="nomProducto" value="<?= $producto->pro_nombre ?>">
                                    </div>
                                </div>
                            </div>


                            <div class="col-md-2">
                                <div class="mb-3 row">
                                    <label for="inputPassword" class="col-sm-4 col-form-label">PVP.</label>
                                    <div class="col-sm-8">
                                        <input type="text" min=1 class="form-control" id="pvpProducto" value="$<?= $model->total ?>" disabled>
                                    </div>
                                </div>
                            </div>



                            <div class="col-md-2">
                                <div class="mb-3 row">
                                    <label for="inputPassword" class="col-sm-4 col-form-label">Saldo</label>
                                    <div class="col-sm-8">
                                        <input type="text" min=1 class="form-control" id="pvpProducto" value="$<?= $model->saldo ?>" disabled>
                                    </div>
                                </div>
                            </div>

                        </div>

                    </div>
                </div>
            </div>

        </div>
    </div>


    <?php
    if ($model->saldo > 0) { ?>
        <div class="row">
            <div class="col-md-3">
                <label for="">Monto $</label>
                <input class="form-control" type="text" id="monto">
            </div>
            <div class="col-md-3">
                <br>
                <button class="btn btn-success" onclick="agregarAbono()">
                    Agregar abono
                </button>
            </div>
        </div>

    <?php   }
    ?>






    <div class="row mt-5">
        <div class="col-md-6">
            <table class="table">
                <thead>
                    <tr>
                        <th>Fecha</th>
                        <th>Monto</th>
                        <th>Saldo</th>
                    </tr>
                </thead>
                <tbody>
                    <?php
                    foreach ($detSeparados as $detalle) {  ?>
                        <tr>
                            <td><?= $detalle->fecha  ?></td>
                            <td><?= number_format($detalle->valor, 2)   ?></td>
                            <td><?= number_format($detalle->saldo, 2)  ?></td>
                        </tr>
                    <?php    }
                    ?>
                </tbody>
            </table>
        </div>
    </div>




</div>



<script>
    window.onload = function() {


        $('#codigoProducto').on('keyup', function(event) {
            let inputValue = $(this).val().trim();

            // Si no es la tecla Enter, prevenimos el comportamiento por defecto
            if (event.key !== 'Enter') {
                event.preventDefault(); // Evitar que otras teclas procesen su efecto
            } else if (inputValue !== '') {
                // Solo llamamos a la función si se presiona Enter y el input no está vacío
                consultaProducto();
            }
        });
    };







    function consultaProducto() {
        let inputValue = $('#codigoProducto').val();

        if (inputValue.trim() !== '') {
            $.get('index.php?r=productos/get-producto&codigo=' + inputValue)
                .done(function(data) {
                    data = JSON.parse(data)
                    if (data.resultado) {
                        $('#nomProducto').val(data.data.pro_nombre);
                        $('#pvpProducto').val(data.data.pro_pvp);

                        $('#cantProducto').val(1);
                        $('#cantProducto').focus();

                    } else {
                        $('#nomProducto').val('');
                        $('#pvpProducto').val('');
                        $('#cantProducto').val();

                        Swal.fire({
                            title: "Oops...",
                            text: data.mensaje ?? 'Producto no encontrado',
                        });
                    }
                })
                .fail(function(xhr, status, error) {
                    console.error('Error en la solicitud:', error);
                });
        }
    }



    function consultaIdentificacion(input) {

        input.value = input.value.replace(/\D/g, '');
        let inputValue = $('#cliIdentificacion').val();
        let factura = ''

        if (inputValue.trim() !== '') {

            $.get('index.php?r=clientes/get-cliente&identificacion=' + inputValue + '&factura=' + factura)
                .done(function(data) {
                    data = JSON.parse(data)
                    console.log(data)
                    if (data.resultado) {

                        $('#cliNombre').val(data.data.cli_nombre)
                        $('#cliEmail').val(data.data.cli_correo)
                        $('#cliFono').val(data.data.cli_telefono)
                        $('#cliDireccion').val(data.data.cli_direccion)
                        $('#cliCelular').val(data.data.cli_celular)

                    } else {
                        /*$('#cliNombre').val('')
                        $('#cliEmail').val('')
                        $('#cliFono').val('')
                        $('#cliCelular').val('')
                        $('#cliDireccion').val('')*/
                    }
                })
                .fail(function(xhr, status, error) {
                    // Manejar el error
                    console.error('Error en la solicitud:', error);
                });
        }
    }





    function agregarAbono(idCliente) {


        let monto = $('#monto').val().trim()
        let id = '<?= $model->id ?>'


        if (monto.trim() !== '') {
            $.get(`index.php?r=detalleseparados/agregar-abono&id=${id}&monto=${monto}`)
                .done(function(data) {
                    data = JSON.parse(data)
                    console.log(data);

                    if (data.transaccion) {


                        Swal.fire({
                            text: data.error ?? 'Se registró el abono con éxito.',
                            icon: 'success'
                        }).then((result) => {
                            if (result.isConfirmed || result.isDismissed) {

                                if (data.emitirNota) {

                                } else {
                                    location.reload();
                                }

                            }
                        });


                    } else {
                        Swal.fire({
                            title: "Oops...",
                            text: data.error ?? 'No pudimos procesar tu solicitud',
                        });
                    }
                })
                .fail(function(xhr, status, error) {
                    // Manejar el error
                    console.error('Error en la solicitud:', error);
                });
        } else {
            Swal.fire({
                title: "Oops...",
                text: data.error ?? 'Por favor ingresa todos los datos solicitados',
            });
        }
    }
</script>