<?php

use app\models\Categorias;
use app\models\Clientes;
use app\models\Empresa;
use app\models\Facturas;
use app\models\Gastos;
use app\models\Parametros;
use app\models\Productos;
use yii\helpers\Html;
use yii\widgets\ActiveForm;

$empresa = Empresa::find()->where(['codigo' => Parametros::empresa])->one();

$clientes = Clientes::find()->where(['cli_estado' => Parametros::ACTIVO])->count();

$gastos = Gastos::find()->where(['gas_estado' => Parametros::ACTIVO])->all();

$categorias = Categorias::find()->where(['cat_estado' => Parametros::ACTIVO])->count();
$productos = Productos::find()
    ->where(['pro_estado' => Parametros::ACTIVO])
    ->andWhere(['>', 'pro_stock', 0])
    ->all();

$suma = 0;
$numProductos = 0;
$sumaFacturas = 0;

$sumaGastos = 0;


$facturas = Facturas::find()->where(['fac_estado' => Parametros::FACT_PAGADA])->select(['fac_total'])->all();


foreach ($productos as $producto) {
    $suma = $suma + ($producto->pro_stock * $producto->pro_costo);
    $numProductos = $numProductos + $producto->pro_stock;
}


foreach ($gastos as $gasto) {
    $sumaGastos = $sumaGastos +   $gasto->gas_valor;
}


foreach ($facturas as $factura) {
    $sumaFacturas = $sumaFacturas + $factura->fac_total;
}


?>

<style>
    h3 {
        text-align: center;
    }

    .seccion {
        cursor: pointer;
    }
</style>


<div class="content-wrapper">
    <!-- Content -->

    <div class="container-xxl flex-grow-1 container-p-y">
        <div class="row">
            <div class="col-lg-12 mb-4 order-0">
                <div class="card">
                    <div class="d-flex align-items-end row">
                        <div class="col-sm-7">
                            <div class="card-body">
                                <h5 class="card-title text-primary">Hola <?= Yii::$app->user->identity->nombre ?> 😄 !</h5>
                                <p class="mb-4">
                                    Te presentamos tu reporte a la fecha
                                </p>


                            </div>
                        </div>
                        <div class="col-sm-5 text-center text-sm-left">
                            <div class="card-body pb-0 px-0 px-md-4">
                                <img
                                    src="../assets/img/illustrations/man-with-laptop-light.png"
                                    height="140"
                                    alt="View Badge User"
                                    data-app-dark-img="illustrations/man-with-laptop-dark.png"
                                    data-app-light-img="illustrations/man-with-laptop-light.png" />
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-lg-4 col-md-4 order-1">
                <div class="row">
                    <div class="col-lg-6 col-md-12 col-6 mb-4">
                        <div class="card seccion" onclick="redirige('productos')">
                            <div class="card-body">
                                <div class="card-title d-flex align-items-start justify-content-between">

                                    <div class="avatar flex-shrink-0">
                                        <img
                                            src="../assets/img/icons/unicons/productos.png"
                                            alt="chart success"
                                            class="rounded" />
                                    </div>

                                </div>
                                <span class="fw-semibold d-block mb-1">Productos (<?= $numProductos ?>)</span>
                                <h3 class="card-title mb-2">$<?= number_format($suma, 2) ?></h3>

                            </div>
                        </div>
                    </div>
                    <div class="col-lg-6 col-md-12 col-6 mb-4">
                        <div class="card seccion" onclick="redirige('facturas')">
                            <div class="card-body">
                                <div class="card-title d-flex align-items-start justify-content-between">
                                    <div class="avatar flex-shrink-0">
                                        <img
                                            src="../assets/img/icons/unicons/ventas.png"
                                            alt="Credit Card"
                                            class="rounded" />
                                    </div>

                                </div>
                                <span>Ventas</span>
                                <h3 class="card-title text-nowrap mb-1">$<?= number_format($sumaFacturas, 2)  ?></h3>

                            </div>
                        </div>
                    </div>
                </div>
            </div>



            <!--/ Total Revenue -->
            <div class="col-12 col-md-8 col-lg-4 order-3 order-md-2">
                <div class="row">
                    <div class="col-6 mb-4">
                        <div class="card seccion" onclick="redirige('clientes')">
                            <div class="card-body">
                                <div class="card-title d-flex align-items-start justify-content-between">
                                    <div class="avatar flex-shrink-0">
                                        <img src="../assets/img/icons/unicons/clientes.png" alt="Credit Card" class="rounded" />
                                    </div>

                                </div>
                                <span class="d-block mb-1">Clientes</span>
                                <h3 class="card-title text-nowrap mb-2"><?= $clientes ?></h3>

                            </div>
                        </div>
                    </div>
                    <div class="col-6 mb-4">
                        <div class="card seccion" onclick="redirige('categorias')">
                            <div class="card-body">
                                <div class="card-title d-flex align-items-start justify-content-between">
                                    <div class="avatar flex-shrink-0">
                                        <img src="../assets/img/icons/unicons/categorias.png" alt="Credit Card" class="rounded" />
                                    </div>

                                </div>
                                <span class="fw-semibold d-block mb-1">Categorias</span>
                                <h3 class="card-title mb-2"><?= $categorias ?></h3>

                            </div>
                        </div>
                    </div>
                    <!-- </div>
    <div class="row"> -->

                </div>
            </div>
        </div>

    </div>
    <!-- / Content -->

    <!-- Footer -->
    <footer class="content-footer footer bg-footer-theme">
        <div class="container-xxl d-flex flex-wrap justify-content-between py-2 flex-md-row flex-column">
            <div class="mb-2 mb-md-0">
                ©
                <script>
                    document.write(new Date().getFullYear());
                </script>
                , desarrollado por Evaksystem

            </div>

        </div>
    </footer>
    <!-- / Footer -->

    <div class="content-backdrop fade"></div>
</div>


<script>
    function redirige(ruta) {
        window.location.href = 'web/index.php?r=' + ruta;
    }
</script>