<?php

use app\models\Empresa;
use app\models\Marcas;
use app\models\Parametros;
use app\models\Productos;
use yii\helpers\Html;

$empresa = Empresa::find()->where(['codigo' => Parametros::empresa])->one();
$productos = Productos::find()->where(['pro_estado' => Parametros::ACTIVO])->all();
?>


<style>
    .etiqueta {
        font-weight: 120;
        font-size: 30px;
        background-color: #f1f1f1;
        padding: 10px 35px;
        border-radius: 55px;
        color: grey
    }


    .card_servicio {
        border: 1px solid white;
        border-radius: 25px;
        padding: 25px 25px 8px 25px;
        width: 22%;
        background-color: #ffffffd9;
    }



    @media (max-width: 767px) {
        .card_servicio {
            width: 80%;
            margin: auto;
            margin-bottom: 20px;
        }
    }

    .card_contacto {
        border: none;
        border-radius: 25px;
        padding: 25px;
        background-color: #ffffff;
        margin: 15px;
        width: 75%;
        margin: auto;
    }


    .btn-card {
        padding: 6px;
        border: none;
        border-radius: 15px;
        color: white;
        background-color: #2e465f;
        opacity: 80%;

    }


    .btn-card:hover {
        padding: 6px;
        border: none;
        border-radius: 15px;
        color: white;
        background-color: #2e465f;
        opacity: 100%;

    }


    @media (max-width: 767px) {
        .display-2 {
            text-align: center;
        }

        .display-3 {
            text-align: center;
        }
    }
</style>


<!-- Bootstrap JS -->
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>



<div class="pt-5 pb-5" style="background-image: url('<?= Yii::$app->urlManager->baseUrl . '/uploads/images/' . $empresa->imagen_banner; ?>'); background-repeat: no-repeat; background-position: center; background-size: cover;">



    <div class="container" id="inicio">
        <div class="row">
            <div class="col-md-4" style="display: flex; flex-direction: column;justify-content: center;">
            <br>
            <img style=" display: block; width: 30%; " class="img-fluid" src="<?= Yii::$app->urlManager->baseUrl . '/uploads/images/' . $empresa->logotipo ?>" alt="">

                <p style=" font-weight: 100; text-align: justify; font-weight: 500; margin-top: 40px;"><?= $empresa->descripcion_banner ?></p><br><br>



            </div>


        </div>
    </div>
</div>






<section style=" background-color: #e5e5e5;">
    <div class=" container-fluid">
        <div class="container">
            <div class="row pt-5 pb-5" style="display: flex; justify-content: space-around;">


                <div class=" card_servicio">
                    <h3 style="color: #37517e;">Venta</h3>
                    <p style="font-size: 14px;">Lorem ipsum dolor sit amet consectetur adipisicing elit. Ullam numquam natus labore similique alias</p>
                    <hr>
                    <a onclick="enviarWhatsApp()" style="width: 100%;" class="btn btn-success"><i class="fa-brands fa-whatsapp"></i> Contactar</a>
                    <br><br>
                </div>

                <div class=" card_servicio">
                    <h3 style="color: #37517e;">Mantenimiento</h3>
                    <p style="font-size: 14px;">Lorem ipsum dolor sit amet consectetur adipisicing elit. Ullam numquam natus labore similique alias</p>
                    <hr>
                    <a onclick="solicitarServicio()" type="button" style="width: 100%;" class="btn btn-secondary">Solicitar mantenimiento</a>
                    <br><br>

                </div>


                <div class=" card_servicio">
                    <h3 style="color: #37517e;">Reparación</h3>
                    <p style="font-size: 14px;">Lorem ipsum dolor sit amet consectetur adipisicing elit. Ullam numquam natus labore similique alias</p>
                    <hr>
                    <a onclick="solicitarReparacion()" type="button" style="width: 100%;" class="btn btn-secondary">Solicitar reparación</a>
                    <br><br>
                </div>



            </div>
        </div>
    </div>

</section>








<section id="catalogo" class="d-none d-md-block" style="background-color: #fff;">
    <div class="container">
        <div class="row" style="padding-top: 60px; padding-bottom: 20px;">

            <div class="row">
                <!--Carreras-->
                <div class="col-md-12">
                    <div class="row py-4">

                        <div class="col-md-12" style="display: flex; flex-direction: row; align-items: center;">



                            <div>
                                <h2 style="color: #37517e;" class="display-4">Tenemos todo lo que necesitas</h2>
                                <p>Trabajamos con las mejores marcas y siempre a los mejores precios</p>
                            </div>

                        </div>


                        <div class="row">
                            <div id="carouselExampleControls" class="carousel carousel-dark slide" data-bs-ride="carousel">

                                <div class="carousel-inner" style="padding-left: 15px; padding-right: 15px;">
                                    <?php
                                    $chunks = array_chunk($productos, 4);
                                    foreach ($chunks as $key => $chunk) {
                                        $activeClass = $key === 0 ? 'active' : ''; // Establecer la primera fila como activa

                                        // Generar una nueva carousel-item para cada trozo de 3 elementos
                                        echo '<div class="carousel-item ' . $activeClass . '">
                                            <div class="row">';

                                        foreach ($chunk as $producto) {
                                            // Generar cada elemento de la fila
                                            $precioNeto = $producto['pro_pvp'];
                                            $precioFinal = $producto['pro_pvp'];
                                            $marcaProd = '';

                                            if (!empty($producto['pro_marca'])) {
                                                $marca = Marcas::find()->where(['mar_id' => $producto['pro_marca']])->one();
                                                $marcaProd =  $marca['mar_nombre'];
                                            }


                                            if (isset($producto['aplicaDescuento']) && $producto['aplicaDescuento'] && !empty($producto['porcDescuento'])) {
                                                $precioFinal = $precioNeto - ($precioNeto / 100 * floatval($producto['porcDescuento']));
                                            }


                                            if (isset($producto['aplicaDescuento']) && $producto['aplicaDescuento']) {
                                                echo '<div class="col-md-3" style="padding: 15px;">
                                                
                                            <div class="card h-100">
                                            <div class="card-body d-grid">
                                            <div style="position: absolute; right: 0px; top: 0px; background-color: #1770ac; color: white; border-radius: 50%; padding: 10px; display: flex; align-items: center; justify-content: center;">
                                                <h5>' . $producto['porcDescuento'] . '%</h5>
                                                <span style="font-size: 13px">Dscto</span>
                                            </div>
                                            <img style="border-radius: 10px; width: 100%" class="card-img-top img-fluid carrera-img" src="' . Yii::$app->urlManager->baseUrl . '/uploads/images/' . $producto['pro_foto'] . '" alt="">
                                            <span style="text-align:center; font-size:20px;margin-bottom:8px; font-weight:500; color:#1770ac">Precio: $' . number_format($precioFinal, 2) . '</span>
        
                                                <span style="text-align:center; font-size:16px;margin-bottom:8px; font-weight:500; color:gray">' . $producto['producto'] . '</span>
                                                <span style="text-align:center; font-size:13px;margin-bottom:8px; font-weight:500; background-color: #f1f1f1; border-radius:20px; color:gray; display: inline-block">' . $producto['marca'] . '</span>
                                                
                                                    ' . Html::a(
                                                    'Ver detalle',
                                                    ['productos/ver-producto', 'id' => $producto['id']],
                                                    ['class' => ' btn-card btn-sm btn-block']
                                                ) . '
                                                </div>
                                            </div>
                                        </div>';
                                            } else {
                                                echo '<div class="col-md-3" style="padding: 15px;">
                                                
                                            <div class="card h-100">
                                            <div class="card-body d-grid">
                                         
                                            <img style="border-radius: 10px; width: 100%" class="card-img-top img-fluid carrera-img" src="' . Yii::$app->urlManager->baseUrl . '/uploads/images/' . $producto['pro_foto'] . '" alt="">
                                            
        
                                                <span style="text-align:center; font-size:16px;margin-bottom:8px; font-weight:500; color:gray">' . $producto['pro_nombre'] . '</span>
                                                <span style="text-align:center; font-size:13px;margin-bottom:8px; font-weight:500; display: inline-block">' . $marcaProd . '</span>
                                                
                                                    ' . Html::a(
                                                    'Ver detalle',
                                                    ['productos/ver-producto', 'id' => $producto['pro_id']],
                                                    ['class' => 'btn btn-card btn-sm btn-block']
                                                ) . '
                                                </div>
                                            </div>
                                        </div>';
                                            }
                                        }

                                        // Calcular el número de tarjetas adicionales necesarias para completar la fila
                                        $remainingCards = count($chunk);
                                        $remainingCols = 4 - $remainingCards;

                                        // Mostrar columnas vacías si es necesario
                                        if ($remainingCols > 0) {
                                            for ($i = 0; $i < $remainingCols; $i++) {
                                                echo '<div class="col-md-3"></div>';
                                            }
                                        }

                                        echo '</div></div>';
                                    }
                                    ?>

                                </div>


                                <button class="carousel-control-prev" type="button" data-bs-target="#carouselExampleControls" data-bs-slide="prev" style="width: auto;">
                                    <span class="carousel-control-prev-icon" aria-hidden="true"></span>
                                    <span class="visually-hidden">Previous</span>
                                </button>
                                <button class="carousel-control-next" type="button" data-bs-target="#carouselExampleControls" data-bs-slide="next" style="width: auto">
                                    <span class="carousel-control-next-icon" aria-hidden="true"></span>
                                    <span class="visually-hidden">Next</span>
                                </button>
                            </div>
                        </div>

                    </div>
                </div>




            </div>

        </div>

        <div class="d-none d-md-block text-center">
            <a href="index.php?r=productos/ver-catalogo" class="btn btn-primary btn-lg heartbeat-button" style="border-radius: 25px; z-index: 20;background-color: #ff9805;">Explora nuestro catálogo</a>
        </div>

    </div>
</section>




<section id="catalogo" class="d-block d-md-none" style="background-color: #fff;">
    <div class="container">

        <div class="row" style="padding-top: 60px; padding-bottom: 20px;">

            <div class="col-md-12">

            </div>

            <!--Carreras-->
            <div class="col-md-12">
                <div class="row py-4">


                    <h2 style="color: #37517e;" class="display-4">Tenemos todo lo que necesitas</h2>
                    <p>Trabajamos con las mejores marcas y siempre a los mejores precios</p>


                    <div id="carouselExampleControls2" class="carousel carousel-dark slide" data-bs-ride="carousel">
                        <div class="carousel-inner" style="padding-left: 15px; padding-right: 15px;">
                            <?php
                            foreach ($productos as $key => $producto) {
                                // Establecer la primera tarjeta como activa
                                $activeClass = $key === 0 ? 'active' : '';

                                // Generar una nueva carousel-item para cada producto
                                echo '<div class="carousel-item ' . $activeClass . '">
                    <div class="col-md-12" >';

                                $precioNeto = $producto['pro_pvp'];
                                $precioFinal = $precioNeto;
                                $marcaProd = '';

                                if (!empty($producto['pro_marca'])) {
                                    $marca = Marcas::find()->where(['mar_id' => $producto['pro_marca']])->one();
                                    $marcaProd = $marca ? $marca['mar_nombre'] : '';
                                }

                                if (isset($producto['aplicaDescuento']) && $producto['aplicaDescuento']) {
                                    $precioFinal = $precioNeto - ($precioNeto / 100 * floatval($producto['porcDescuento']));
                                }

                                echo '<div class="card h-100">
                        <div class="card-body d-grid">';

                                if (isset($producto['aplicaDescuento']) && $producto['aplicaDescuento']) {
                                    echo '<div style="position: absolute; right: 0px; top: 0px; background-color: #1770ac; color: white; border-radius: 50%; padding: 10px;">
                            <h5>' . $producto['porcDescuento'] . '%</h5>
                            <span style="font-size: 13px">Dscto</span>
                        </div>';
                                }

                                echo '<img style="border-radius: 10px; width: 100%" class="card-img-top img-fluid carrera-img" src="' . Yii::$app->urlManager->baseUrl . '/uploads/images/' . $producto['pro_foto'] . '" alt="">
                      
                      <span style="text-align:center; font-size:16px;margin-bottom:8px; font-weight:500; color:gray">' . $producto['pro_nombre'] . '</span>
                      <span style="text-align:center; font-size:13px;margin-bottom:8px; font-weight:500; display: inline-block">' . $marcaProd . '</span>
                      ' . Html::a('Ver detalle', ['productos/ver-producto', 'id' => $producto['pro_id']], ['class' => 'btn btn-card btn-sm btn-block']) . '
                    </div>
                </div>';

                                echo '</div></div>'; // Cierre de col y carousel-item
                            }
                            ?>
                        </div>

                        <button class="carousel-control-prev" type="button" data-bs-target="#carouselExampleControls2" data-bs-slide="prev" style="width: auto;">
                            <span class="carousel-control-prev-icon" aria-hidden="true"></span>
                            <span class="visually-hidden">Previous</span>
                        </button>
                        <button class="carousel-control-next" type="button" data-bs-target="#carouselExampleControls2" data-bs-slide="next" style="width: auto;">
                            <span class="carousel-control-next-icon" aria-hidden="true"></span>
                            <span class="visually-hidden">Next</span>
                        </button>
                    </div>
                </div>


            </div>





        </div>

        <div class=" text-center">
            <a href="index.php?r=productos/ver-catalogo" class="btn btn-primary btn-lg heartbeat-button" style="border-radius: 25px; z-index: 20;background-color: #05acac;">Explora nuestro catálogo</a>
        </div>

    </div>
</section>




<!-- INSTITUTO -->
<section class=" pb-5 pt-5 " id="contactanos" style="margin-top:75px; background-color: #efefef;">

    <div class="container">
        <div class="row" style="display: flex; align-items: center; padding-top: 30px; padding-bottom: 30px;  color:grey">

            <div class="col-md-4">

                <a target="_blank" href="<?= $empresa->googlemaps ?>">
                    <img style="display: block; margin: auto; width:90%" class="img-fluid" src="<?= Yii::$app->urlManager->baseUrl . '/uploads/images/' . $empresa->mapa ?>" alt="">
                </a>
                <br>
                <p class="text-center" style="font-size: 13px;">Presiona sobre el mapa para ver la ubicación</p>


            </div>

            <div class="col-md-8">
                <h2 class="display-3" style="color: #37517e;">Contáctanos</h2>
                <p>
                    ¿Tienes alguna inquietud? No dudes en contactarnos, estamos listos para atenderte.
                </p>
                <br>

                <div class="card_contacto">

                    <div class="row">
                        <div class="col-md-4">
                            <img style="display: block; margin: auto; " class="img-fluid" src="<?= Yii::$app->urlManager->baseUrl . '/uploads/images/contactanos.png' ?>" alt="">
                        </div>
                        <div class="col-md-8">
                            <h3 style="color:#08326f"> Horario de atención:</h3>


                            <?php
                            $horarios = explode(',', $empresa->horario_atencion);

                            foreach ($horarios as $horario) { ?>
                                <p><?= $horario ?></p>
                            <?php }
                            ?>


                            <hr>

                            <p>Llámanos al: <?= $empresa->telefonos ?></p>

                            <hr>

                            <p>Ubícanos en: <?= $empresa->direccion ?></p>
                        </div>
                    </div>



                </div>


            </div>



        </div>
    </div>
    </div>

</section>






        <!-- Modal -->
        <div class="modal fade" id="exampleModal" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
  <div class="modal-dialog modal-md">
    <div class="modal-content">
      <div class="modal-header" style="background-color: #37517e;">
        <h5 class="modal-title" style="color: white;" id="exampleModalLabel">Mantenimiento</h5>
        <button type="button"  class="btn-close" data-bs-dismiss="modal" aria-label="Close" style="color: white;" ></button>
      </div>
      <div class="modal-body" style="width: 90%; margin: auto;">


      <div class="row">
        
      <div style="padding: 5%;">
          <form id="miFormulario" enctype="multipart/form-data">

            <h5>Ingresa tu solicitud aquí</h5>


                <label>Nombre:</label>
                <input id="nombre" class="form-control" type="text" required><br>

                <label>Celular de contacto:</label>
                <input id="celular" class="form-control" type="text" minlength="10" maxlength="10" required><br>

                <label>Dirección y sector:</label>
                <input id="direccion" class="form-control" type="text" required><br>


                <label>Detalle:</label>
                <textarea required class="form-control" name="detalle" id="detalle" cols="3" placeholder="Danos un poco más de detalle de lo que necesitas..."></textarea>


                <div style="display: flex; justify-content: flex-end; margin-top: 12px; ">
                <button id="enviarBtn" class="btn btn-primary" style="background-color: #37517e;">
                    Enviar solicitud  <i class="fa-regular fa-paper-plane" style="margin-left: 8px;"></i>
                </button>  
            </div>
                
            </form>
          </div>

      </div>


      </div>

    </div>
  </div>
</div>



<!-- Modal -->
<div class="modal fade" id="exampleModal2" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
  <div class="modal-dialog modal-md">
    <div class="modal-content">
      <div class="modal-header" style="background-color: #37517e;">
        <h5 class="modal-title" style="color: white;" id="exampleModalLabel">Reparación</h5>
        <button type="button"  class="btn-close" data-bs-dismiss="modal" aria-label="Close" style="color: white;" ></button>
      </div>
      <div class="modal-body" style="width: 90%; margin: auto;">


      <div class="row">
        
      <div style="padding: 5%;">
          <form id="miFormulario2" enctype="multipart/form-data">

            <h5>Ingresa tu solicitud aquí</h5>


                <label>Nombre:</label>
                <input id="nombre2" class="form-control" type="text" required><br>

                <label>Celular de contacto:</label>
                <input id="celular2" class="form-control" type="text" minlength="10" maxlength="10" required><br>

                <label>Dirección y sector:</label>
                <input id="direccion2" class="form-control" type="text" required><br>


                <label>Detalle:</label>
                <textarea required class="form-control" name="detalle" id="detalle2" cols="3" placeholder="Danos un poco más de detalle de lo que necesitas..."></textarea>


                <div style="display: flex; justify-content: flex-end; margin-top: 12px; ">
                <button id="enviarBtn" class="btn btn-primary" style="background-color: #37517e;">
                    Enviar solicitud  <i class="fa-regular fa-paper-plane" style="margin-left: 8px;"></i>
                </button>  
            </div>
                
            </form>
          </div>

      </div>


      </div>

    </div>
  </div>
</div>



<script>
    function enviarWhatsApp(tipo) {
        let mensaje = 'Hola deseo más información por favor';


        var url = "https://api.whatsapp.com/send?phone=593" + <?= $empresa->whatsapp ?> + "&text=" + encodeURIComponent(mensaje);
        window.open(url, '_blank');
    }
</script>



<script>


$(document).ready(function () {


    document.getElementById("nombre").addEventListener("keyup", function (event) {
        const regex = /^[a-zA-ZÀ-ÿ\s]*$/; // Letras, espacios y tildes
        if (!regex.test(this.value)) {
            this.value = this.value.slice(0, -1); // Elimina el último carácter no válido
        }
    });

    // Validación para que el campo "celular" solo acepte números
    document.getElementById("celular").addEventListener("keyup", function (event) {
        const regex = /^[0-9]*$/; // Solo números
        if (!regex.test(this.value)) {
            this.value = this.value.slice(0, -1); // Elimina el último carácter no válido
        }
    });



    document.getElementById("nombre2").addEventListener("keyup", function (event) {
        const regex = /^[a-zA-ZÀ-ÿ\s]*$/; // Letras, espacios y tildes
        if (!regex.test(this.value)) {
            this.value = this.value.slice(0, -1); // Elimina el último carácter no válido
        }
    });

    // Validación para que el campo "celular" solo acepte números
    document.getElementById("celular2").addEventListener("keyup", function (event) {
        const regex = /^[0-9]*$/; // Solo números
        if (!regex.test(this.value)) {
            this.value = this.value.slice(0, -1); // Elimina el último carácter no válido
        }
    });



        $("#miFormulario").submit(function (event) {
          
            event.preventDefault(); // Previene la acción predeterminada del formulario


            // Obtiene los valores de los campos del formulario
            var nombre = $("#nombre").val();
            var celular = $("#celular").val();
            var direccion = $("#direccion").val();
            var detalle = $("#detalle").val();
            var tipo = 'mant';


            // Crea un objeto FormData para enviar datos binarios como archivos
            var formData = new FormData();
            formData.append("nombre", nombre);
            formData.append("celular", celular);
            formData.append("direccion", direccion);
            formData.append("detalle", detalle);
            formData.append("tipo", tipo);

            // Envía los datos mediante $.post
            $.ajax({
                url: "index.php?r=solicitudes/ingresar-solicitud",
                type: "POST",
                data: formData,
                contentType: false,
                processData: false,
                success: function (response) {

                  response = JSON.parse(response)

                  if(response.transaccion){

                    $("#nombre").val('');
                    $("#celular").val('');
                    $("#direccion").val('');
                    $("#detalle").val('');
                  

                    Swal.fire({
                        title: "¡Excelente!",
                        text: "Tu solicitud ha sido enviada, pronto uno de nuestros asesores se pondrá en contacto contigo.",
                        icon: "success", // Puedes agregar un ícono si deseas
                        confirmButtonText: "Entendido"

                    }).then((result) => {
                        if (result.isConfirmed) {
                            $('#exampleModal').modal('hide');
                        }
                    });

                    
                  }else{

                      Swal.fire({
                        title: "",
                        text: response.error,
                        icon: "error"
                      });

                  }
                    
                },
                error: function (error) {
                    // Maneja el error
                    console.log(error);
                }
            });
        });


        $("#miFormulario2").submit(function (event) {
          
          event.preventDefault(); // Previene la acción predeterminada del formulario


          // Obtiene los valores de los campos del formulario
          var nombre = $("#nombre2").val();
          var celular = $("#celular2").val();
          var direccion = $("#direccion2").val();
          var detalle = $("#detalle2").val();
          var tipo = 'rep';


          // Crea un objeto FormData para enviar datos binarios como archivos
          var formData = new FormData();
          formData.append("nombre", nombre);
          formData.append("celular", celular);
          formData.append("direccion", direccion);
          formData.append("detalle", detalle);
          formData.append("tipo", tipo);

          // Envía los datos mediante $.post
          $.ajax({
              url: "index.php?r=solicitudes/ingresar-solicitud",
              type: "POST",
              data: formData,
              contentType: false,
              processData: false,
              success: function (response) {

                response = JSON.parse(response)

                if(response.transaccion){

                  $("#nombre2").val('');
                  $("#celular2").val('');
                  $("#direccion2").val('');
                  $("#detalle2").val('');
                

                  Swal.fire({
                      title: "¡Excelente!",
                      text: "Tu solicitud ha sido enviada, pronto uno de nuestros asesores se pondrá en contacto contigo.",
                      icon: "success", // Puedes agregar un ícono si deseas
                      confirmButtonText: "Entendido"

                  }).then((result) => {
                      if (result.isConfirmed) {
                          $('#exampleModal2').modal('hide');
                      }
                  });

                  
                }else{

                    Swal.fire({
                      title: "",
                      text: response.error,
                      icon: "error"
                    });

                }
                  
              },
              error: function (error) {
                  // Maneja el error
                  console.log(error);
              }
          });
      });
    });

    function irWhat(){
        const url ='https://api.whatsapp.com/send/?phone=593983506119&text=Hola%2C+por+favor+deseo+obtener+m%C3%A1s+informaci%C3%B3n&type=phone_number&app_absent=0'
        window.open(url, '_blank');
    }



    function solicitarServicio(codigo){
        $('#exampleModal').modal('show');
    }


    function solicitarReparacion(codigo){
        $('#exampleModal2').modal('show');
    }



    function mostrarEvento(id){
                
      $.get('index.php?r=eventos/get-evento', {id:id}, function(response){
        
        response= JSON.parse(response)
        
        if(response.transaccion){
          
          $('#tituloEvento').html('<h4 style="color: #5b5b5b">' + response.evento['evento'] + '</h4>');
          $('#detalleEvento').html(response.evento['descripcion']);

          let ruta = '<?= Yii::$app->urlManager->baseUrl.'/uploads/images/'?>'+response.evento['imagen'];
          
          $('#imagenEvento').html('<img class="img-fluid" src="'+ruta+'" />')
          
          $('#modalEvento').modal('show');
        }else{
          alert('Lo sentimos, por el momento no podemos procesar tu solicitud')
        }
      })
    }
        


        
    
</script>