<?php

use yii\helpers\Html;
use yii\widgets\ActiveForm;

$this->title = 'Registro de usuarios';
$this->params['breadcrumbs'][] = $this->title;
?>

<h1><?= Html::encode($this->title) ?></h1>

<?php $form = ActiveForm::begin(); ?>

<div class="row">


  <div class="col-md-6">

    <div class="card mb-4">
      <h5 class="card-header">Registro de usuarios</h5>
      <div class="card-body">
        <div>

          <!-- input -->


          <?= $form->field($model, 'id')->label('Identificación')->textInput(['autofocus' => true, 'maxlength' => true]) ?>


          <?= $form->field($model, 'nombre') ?>


          <?= $form->field($model, 'username')->label('Usuario') ?>


          <?= $form->field($model, 'email') ?>





          <?= $form->field($model, 'password')->passwordInput() ?>



          <?= $form->field($model, 'rol')->dropDownList([
            'superAdmin' => 'Super administrador',
            'vendedor' => 'Vendedor'
          ]) ?>



          <?= $form->field($model, 'estado')->dropDownList([
            'A' => 'Activo',
            'I' => 'Inactivo'
          ]) ?>



        </div>
      </div>
    </div>

  </div>



</div>


<br>
<div class="form-group">
  <?= Html::submitButton('Guardar', ['class' => 'btn btn-success']) ?>
</div>

<?php ActiveForm::end(); ?>