<?php

use app\models\Parametros;
use app\models\User;
use yii\helpers\ArrayHelper;
use yii\helpers\Html;
use yii\widgets\ActiveForm;

/** @var yii\web\View $this */
/** @var app\models\Solicitudes $model */
/** @var yii\widgets\ActiveForm $form */

$usuarios = User::find()->where(['estado' => Parametros::ACTIVO])->all();
$listaUsuarios = ArrayHelper::map($usuarios, 'id', 'nombre');

// Verificar si el usuario es administrador
$userModel = Yii::$app->user->identity;
$esAdmin = !empty($userModel->rol) && $userModel->rol === 'superAdmin';

// Verificar si la solicitud ya está resuelta
$esResuelto = isset($model->estado) && $model->estado === 'Resuelto';

// Si está resuelto, nada editable
$editable = !$esResuelto;

// Si no es admin, solo puede editar 'respuesta'
$soloRespuesta = !$esAdmin && !$esResuelto;
?>

<div class="solicitudes-form">

    <?php $form = ActiveForm::begin(); ?>

    <div class="row">
        <div class="col-md-6">
            <div class="card mb-4">
                <h5 class="card-header">Datos personales</h5>
                <div class="card-body">
                    <?= $form->field($model, 'nombre')->textInput([
                        'maxlength' => true,
                        'readonly' => !$editable || !$esAdmin
                    ]) ?>

                    <?= $form->field($model, 'celular')->textInput([
                        'maxlength' => true,
                        'readonly' => !$editable || !$esAdmin
                    ]) ?>

                    <?= $form->field($model, 'tipo')->dropDownList(
                        ['mant' => 'Mantenimiento', 'rep' => 'Reparación'],
                        ['disabled' => !$editable || !$esAdmin]
                    ) ?>

                    <?= $form->field($model, 'comentario')->textarea([
                        'rows' => 6,
                        'readonly' => !$editable || !$esAdmin
                    ]) ?>

                    <?= $form->field($model, 'dirección')->textInput([
                        'maxlength' => true,
                        'readonly' => !$editable || !$esAdmin
                    ]) ?>
                </div>
            </div>
        </div>

        <div class="col-md-6">
            <div class="card mb-4">
                <h5 class="card-header">Proceso de gestión</h5>
                <div class="card-body">
                    <?= $form->field($model, 'responsable')->dropDownList(
                        $listaUsuarios,
                        ['disabled' => !$editable || !$esAdmin]
                    ) ?>

                    <?= $form->field($model, 'estado')->dropDownList(
                        ['Pendiente' => 'Pendiente', 'Resuelto' => 'Resuelto'],
                        ['disabled' => !$editable || !$esAdmin]
                    ) ?>

                    <?= $form->field($model, 'respuesta')->textarea([
                        'rows' => 6,
                        'readonly' => !$editable || (!$esAdmin && !$soloRespuesta)
                    ]) ?>
                </div>
            </div>
        </div>
    </div>

    <div class="form-group">
        <?= Html::submitButton('Guardar', [
            'class' => 'btn btn-success',
            'disabled' => !$editable // si está resuelto, no se puede guardar
        ]) ?>
    </div>

    <?php ActiveForm::end(); ?>

</div>
