<?php

use app\models\Parametros;
use app\models\Tipogastos;
use app\models\User;
use yii\helpers\Html;
use yii\helpers\Url;
use yii\grid\ActionColumn;
use yii\grid\GridView;
use Yii;

/** @var yii\web\View $this */
/** @var app\models\TipogastosSearch $searchModel */
/** @var yii\data\ActiveDataProvider $dataProvider */

$this->title = 'Tipo de gastos';
$this->params['breadcrumbs'][] = $this->title;
$userModel = Yii::$app->user->identity;
$esAdmin = false;


if (!empty($userModel->rol) && $userModel->rol === 'superAdmin') {
    $esAdmin = true;
}
?>


<div class="tipogastos-index">

    <h1><?= Html::encode($this->title) ?></h1>

    <p>
        <?php
        if ($esAdmin) {
            echo Html::a('Crear tipo de Gasto', ['create'], ['class' => 'btn btn-success']);
        }
        ?>


    </p>


    <?php // echo $this->render('_search', ['model' => $searchModel]); 
    ?>

    <div class="row">
        <div class="col-lg-12 mb-4 order-0">
            <div class="card">
                <div class="d-flex align-items-end row">
                    <div class="col-sm-12">
                        <div class="card-body">


                            <?= GridView::widget([
                                'dataProvider' => $dataProvider,
                                'filterModel' => $searchModel,
                                'columns' => [
                                    ['class' => 'yii\grid\SerialColumn'],

                                    //  'tip_gasto_id',
                                    'tip_gasto_nombre',

                                    //  'updated_at',
                                    // 'created_by',
                                    //'updated_by',

                                    [
                                        'attribute' => 'tip_estado',
                                        'value' => function ($model) {
                                            return $model->tip_estado === Parametros::ACTIVO ? 'Activo' : 'Inactivo';
                                        },
                                        'filter' => ['A' => 'Activo', 'I' => 'Inactivo'], // Opcional, para agregar el filtro en el GridView
                                    ],

                                    [
                                        'attribute' => 'created_by',
                                        'value' => function ($model) {
                                            $user = User::find()->where(['id' => $model->created_by])->one();
                                            return $user->nombre;
                                        },

                                    ],





                                    // 'created_at',
                                    [
                                        'class' => ActionColumn::className(),
                                        'urlCreator' => function ($action, Tipogastos $model, $key, $index, $column) {
                                            return Url::toRoute([$action, 'tip_gasto_id' => $model->tip_gasto_id]);
                                        },
                                        'visibleButtons' => [ // Configurar la visibilidad de los botones según la variable $admin
                                            'update' => function ($model, $key, $index) use ($esAdmin) {

                                                return $esAdmin; // Solo muestra el botón si $admin es true
                                            },
                                            'view' => function ($model, $key, $index) use ($esAdmin) {
                                                return $esAdmin; // Solo muestra el botón si $admin es true
                                            },
                                            'delete' => function ($model, $key, $index) use ($esAdmin) {
                                                return $esAdmin; // Solo muestra el botón si $admin es true
                                            },
                                        ],
                                        'buttons' => [
                                            'delete' => function ($url, $model, $key) {
                                                return Html::a('<i class="fas fa-trash"></i>', $url, [
                                                    'title' => Yii::t('app', 'Eliminar'), // Título del botón (opcional)
                                                    'data-confirm' => '¿Estás seguro de que deseas eliminar este elemento?', // Mensaje en español
                                                    'data-method' => 'post', // Método para eliminar
                                                    'data-pjax' => '0', // Si usas Pjax, esto previene la actualización por Ajax
                                                ]);
                                            },
                                        ],
                                    ],
                                ],
                            ]); ?>


                        </div>
                    </div>

                </div>
            </div>
        </div>
    </div>




</div>