<?php

use app\models\Parametros;
use app\models\User;
use yii\helpers\Html;
use yii\helpers\Url;
use yii\grid\ActionColumn;
use yii\grid\GridView;

/** @var yii\web\View $this */
/** @var app\models\UserSearch $searchModel */
/** @var yii\data\ActiveDataProvider $dataProvider */

$this->title = 'Usuarios';
$this->params['breadcrumbs'][] = $this->title;
?>

<div class="user-index">

  <h1><?= Html::encode($this->title) ?></h1>

  <p>
    <?= Html::a('Crear usuario', ['create'], ['class' => 'btn btn-success ']) ?>
  </p>



  <div class="row">
    <div class="col-lg-12 mb-4 order-0">
      <div class="card">
        <div class="d-flex align-items-end row">
          <div class="col-sm-12">
            <div class="card-body">

              <?= GridView::widget([
                'dataProvider' => $dataProvider,
                'filterModel' => $searchModel,
                'columns' => [
                  ['class' => 'yii\grid\SerialColumn'],

                  'username',
                  'email:email',
                  'rol',
                  'nombre',
                  [
                    'attribute' => 'estado',
                    'value' => function ($model) {
                      return $model->estado === Parametros::ACTIVO ? 'Activo' : 'Inactivo';
                    },
                    'filter' => ['A' => 'Activo', 'I' => 'Inactivo'], // Opcional, para agregar el filtro en el GridView
                  ],
                  //'id',
                  [
                    'class' => ActionColumn::className(),
                    'urlCreator' => function ($action, User $model, $key, $index, $column) {
                      return Url::toRoute([$action, 'id' => $model->id]);
                    },
                    'buttons' => [
                      'delete' => function ($url, $model, $key) {
                        return Html::a('<i class="fas fa-trash"></i>', $url, [
                          'title' => Yii::t('app', 'Eliminar'), // Título del botón (opcional)
                          'data-confirm' => '¿Estás seguro de que deseas eliminar este elemento?', // Mensaje en español
                          'data-method' => 'post', // Método para eliminar
                          'data-pjax' => '0', // Si usas Pjax, esto previene la actualización por Ajax
                        ]);
                      },
                    ],
                    'visibleButtons' => [
        'delete' => false, // Esto asegura que nunca intente renderizar el botón de eliminar
    ],
                  ],
                ],
              ]); ?>



            </div>
          </div>

        </div>
      </div>
    </div>
  </div>




</div>