<?php

use app\models\Parametros;
use yii\helpers\Html;
use yii\widgets\DetailView;

/** @var yii\web\View $this */
/** @var app\models\User $model */

$this->title = $model->id;
$this->params['breadcrumbs'][] = ['label' => 'Users', 'url' => ['index']];
$this->params['breadcrumbs'][] = $this->title;
\yii\web\YiiAsset::register($this);
?>
<div class="user-view">

    <h1><?= Html::encode($this->title) ?></h1>

    <p>
        <?= Html::a('Actualizar', ['update', 'id' => $model->id], ['class' => 'btn btn-success btn-sm']) ?>

    </p>

    <?= DetailView::widget([
        'model' => $model,
        'attributes' => [
            'id',
            'username',
            'email:email',
            // 'password',
            'rol',
            'nombre',

            [
                'attribute' => 'estado',
                'value' => function ($model) {
                    return $model->estado === Parametros::ACTIVO ? 'Activo' : 'Inactivo';
                },

            ],

        ],
    ]) ?>

</div>