<?php

use app\models\Clientes;
use app\models\Facturas;
use app\models\Parametros;
use app\models\User;
use yii\helpers\Html;
use yii\helpers\Url;
use yii\grid\ActionColumn;
use yii\grid\GridView;
use yii\helpers\ArrayHelper;

$usuarios = User::find()->all();
$arrayUsuarios = ArrayHelper::map($usuarios, 'id', 'nombre');

$today = date('Y-m-d');

/** @var yii\web\View $this */
/** @var app\models\FacturasSearch $searchModel */
/** @var yii\data\ActiveDataProvider $dataProvider */

$this->title = 'Notas de Venta';
$this->params['breadcrumbs'][] = $this->title;
?>

<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>

<div class="facturas-index">
    <div class="row">
        <div class="col-md-12">
            <h2>Cuadre de caja</h2>
        </div>
        <hr>
        <div class="col-md-2">
            <label for="inicio">Fecha</label>
            <input class="form-control" type="date" id="inicio" max="" value="<?= $today ?>">
        </div>
        <div class="col-md-2">
            <br>
            <button class="btn btn-success" onclick="consultaValores()">Consultar</button>
        </div>
    </div>

    <div class="row">
        <div class="col-md-12 text-center pt-5">
            <span style="font-size: 20px; border-right: 2px solid white; color: #515050; display: inline-block; padding-right: 10px; padding-left: 10px; text-align: center;">$ <span id='totalFact'></span> <br> <span style="font-size: 14px;">Total facturas</span> </span>
            <span style="font-size: 20px; border-right: 2px solid white; color: #515050; display: inline-block; padding-right: 10px; padding-left: 10px; text-align: center;">$ <span id='totalEfect'></span> <br> <span style="font-size: 14px;">Total Efectivo</span> </span>
            <span style="font-size: 20px; border-right: 2px solid white; color: #515050; display: inline-block; padding-right: 10px; padding-left: 10px; text-align: center;">$ <span id='totalTrans'></span> <br> <span style="font-size: 14px;">Total Transferencias</span> </span>
            <span style="font-size: 20px; border-right: 2px solid white; color: #515050; display: inline-block; padding-right: 10px; padding-left: 10px; text-align: center;">$ <span id='totalTar'></span> <br> <span style="font-size: 14px;">Total Tarjetas</span> </span>
            <span style="font-size: 20px; border-right: 2px solid white; color: #515050; display: inline-block; padding-right: 10px; padding-left: 10px; text-align: center;">$ <span id='totalCosto'></span> <br> <span style="font-size: 14px;">Total Costo</span> </span>
            <span style="font-size: 20px; color: #515050; display: inline-block; padding-left: 10px; text-align: center;">$ <span id='totalGanancias'></span> <br> <span style="font-size: 14px;">Total Ganancias</span> </span>
        </div>
    </div>

    <br><br><br>

    <div class="row">
        <div class="offset-md-4 col-md-4">
            <div>
                <canvas id="myChart"></canvas>
            </div>
        </div>
    </div>
</div>



<script>
    // Declarar chartInstance globalmente
    let chartInstance;

    // Definir la función consultaValores globalmente
    function consultaValores() {
        let inicio = document.getElementById('inicio').value;

        $.get(`index.php?r=valores/consulta-valores&fecha=${inicio}`)
            .done(function (data) {
                data = JSON.parse(data);

                if (data.transaccion) {
                    document.getElementById('totalFact').innerHTML = data.totalFacturas;
                    document.getElementById('totalEfect').innerHTML = data.totalFacturaEfectivo;
                    document.getElementById('totalTrans').innerHTML = data.totalFacturaTransferencia;
                    document.getElementById('totalTar').innerHTML = data.totalFacturaTarjeta;
                    document.getElementById('totalCosto').innerHTML = data.totalCosto;
                    document.getElementById('totalGanancias').innerHTML = data.totalGanancia;

                    // Destruir el gráfico existente si ya fue creado
                    if (chartInstance) {
                        chartInstance.destroy();
                    }

                    // Crear un nuevo gráfico
                    const ctx = document.getElementById('myChart');
                    chartInstance = new Chart(ctx, {
                        type: 'doughnut',
                        data: {
                            labels: ['Efectivo', 'Transferencia', 'Tarjeta'],
                            datasets: [{
                                label: 'Cuadre de caja',
                                data: [data.totalFacturaEfectivo, data.totalFacturaTransferencia, data.totalFacturaTarjeta],
                                borderWidth: 1
                            }]
                        },
                        options: {
                            responsive: true,
                            plugins: {
                                legend: {
                                    position: 'top',
                                },
                                tooltip: {
                                    callbacks: {
                                        label: function (context) {
                                            return `${context.label}: $${context.raw.toFixed(2)}`;
                                        }
                                    }
                                }
                            }
                        }
                    });
                }
            })
            .fail(function (xhr, status, error) {
                console.error('Error en la solicitud:', error);
            });
    }

    $(window).on('load', function() {
        consultaValores();
    });

    document.addEventListener('DOMContentLoaded', function () {
        // Obtener la fecha de hoy en formato YYYY-MM-DD
        const today = new Date().toISOString().split('T')[0];

        // Asignar la fecha de hoy como el valor máximo permitido
        document.getElementById('inicio').setAttribute('max', today);
    });

    // Asignar la función al evento de clic del botón
    document.querySelector('.btn-success').addEventListener('click', consultaValores);
</script>
